/*
 * Rahmenwerk-Plug-in "Benutzerverwaltung/Zugriffsrechte"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.benutzervew.editor.region;

import org.eclipse.jface.wizard.Wizard;

import de.bsvrz.buv.plugin.benutzervew.editor.KonfigurationsbereichWizardPage;
import de.bsvrz.buv.plugin.benutzervew.editor.KonfigurationsverantwortlicheWizardPage;
import de.bsvrz.buv.plugin.benutzervew.editor.ObjektTypenWizardPage;
import de.bsvrz.sys.funclib.bitctrl.modell.att.Attributliste;
import de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AtlAusgeschlosseneObjekte;
import de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AtlBereiche;
import de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AtlEnthalteneObjekte;

/**
 * Assistent für die Parametrierung der {@link AtlBereiche} ab einer Region.
 *
 * @author BitCtrl Systems GmbH, ChHoesel
 *
 */
public class BereicheWizard extends Wizard {

	private Attributliste daten;
	private AtlBereiche bereich;
	private KonfigurationsverantwortlicheWizardPage konfigurationsverantwortlicheWizardPage;
	private KonfigurationsbereichWizardPage konfigurationsbereichWizardPage;
	private ObjektTypenWizardPage objektTypenWizardPage;
	private MengenBezeichnungWizardPage bereicheWizardPage;

	public BereicheWizard(Attributliste daten) {
		setWindowTitle("Bereiche Assistent");
		this.daten = daten;
	}

	public BereicheWizard(AtlBereiche bereich) {
		setWindowTitle("Bereiche Assistent");
		this.bereich = bereich;
	}

	@Override
	public void addPages() {

		konfigurationsverantwortlicheWizardPage = new KonfigurationsverantwortlicheWizardPage();
		konfigurationsbereichWizardPage = new KonfigurationsbereichWizardPage();
		objektTypenWizardPage = new ObjektTypenWizardPage();
		bereicheWizardPage = new MengenBezeichnungWizardPage();
		if (bereich != null) {
			konfigurationsverantwortlicheWizardPage
					.setVerwendeteKonfigurationsVerantwortlicher(bereich.getKonfigurationsverantwortlicher());
			konfigurationsbereichWizardPage.setVerwendeteKonfigurationsBereiche(bereich.getKonfigurationsbereich());
			objektTypenWizardPage.setVerwendeteObjektTypen(bereich.getTyp());
			bereicheWizardPage.setMengenBezeichnung(bereich.getMengenbezeichnung());
		}
		addPage(konfigurationsverantwortlicheWizardPage);
		addPage(konfigurationsbereichWizardPage);
		addPage(objektTypenWizardPage);
		addPage(bereicheWizardPage);
	}

	@Override
	public boolean performFinish() {
		if (bereich == null) {
			bereich = new AtlBereiche();
			if (daten instanceof AtlEnthalteneObjekte) {
				((AtlEnthalteneObjekte) daten).getBereich().add(bereich);
			} else if (daten instanceof AtlAusgeschlosseneObjekte) {
				((AtlAusgeschlosseneObjekte) daten).getBereich().add(bereich);
			} else {
				throw new IllegalArgumentException(
						"Der Bereiche Assistent kann nur die Attributlisten " + AtlEnthalteneObjekte.class.getName()
								+ " & " + AtlAusgeschlosseneObjekte.class.getName() + " verarbeiten.");
			}
		}

		bereich.getKonfigurationsverantwortlicher().clear();
		bereich.getKonfigurationsverantwortlicher()
				.addAll(konfigurationsverantwortlicheWizardPage.getVerwendeteKonfigurationsVerantwortlicher());

		bereich.getKonfigurationsbereich().clear();
		bereich.getKonfigurationsbereich()
				.addAll(konfigurationsbereichWizardPage.getVerwendeteKonfigurationsBereiche());

		bereich.getTyp().clear();
		bereich.getTyp().addAll(objektTypenWizardPage.getVerwendeteObjektTypen());

		bereich.setMengenbezeichnung(bereicheWizardPage.getMengenBezeichnung());

		return true;
	}

}
