/*
 * Rahmenwerk-Plug-in "Benutzerverwaltung/Zugriffsrechte"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.benutzervew.editor.region;

import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.plugin.AbstractUIPlugin;

import de.bsvrz.buv.plugin.benutzervew.PluginBenutzerVew;

public class MengenBezeichnungWizardPage extends WizardPage {
	private Text textMengenbezeichnung;

	private String mengenBezeichnung = "";

	public MengenBezeichnungWizardPage() {
		super(MengenBezeichnungWizardPage.class.getName());
		setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin(PluginBenutzerVew.PLUGIN_ID,
				"icons/mengen_bezeichnung_wizard_page.gif"));
		setTitle("Mengen");
		setDescription("Weitere Eigenschaften festlegen.");
	}

	@Override
	public void createControl(Composite parent) {
		final Composite container = new Composite(parent, SWT.NONE);

		setControl(container);
		container.setLayout(new GridLayout(2, false));

		final Label lblMengenbezeichnung = new Label(container, SWT.NONE);
		lblMengenbezeichnung.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
		lblMengenbezeichnung.setText("Mengenbezeichnung:");

		textMengenbezeichnung = new Text(container, SWT.BORDER);
		textMengenbezeichnung.setToolTipText(
				"Über die Vorgabe eines Mengennamens können die Objekte ausgewählt werden, die in Mengen dieses Namens bei den ausgewählten Objekten enthalten sind. Ist hier z.B. als Menge \"FahrStreifen\" angegeben, wird für alle bisher ausgewählten Objekte geprüft, ob an dem Konfigurationsobjekt eine Menge dieses Namens vorhanden ist und für diesen Fall werden die enthaltenen Konfigurationsobjekte betrachtet. Wenn hier keine Angabe erfolgt, bleibt die Auswahl bestehen. ");
		textMengenbezeichnung.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		textMengenbezeichnung.setText(mengenBezeichnung);
	}

	public final String getMengenBezeichnung() {
		return textMengenbezeichnung.getText();
	}

	public final void setMengenBezeichnung(String mengenBezeichnung) {
		this.mengenBezeichnung = mengenBezeichnung;
	}
}
