/*
 * Rahmenwerk-Plug-in "Benutzerverwaltung/Zugriffsrechte"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.benutzervew.editor.region;

import java.util.stream.Collectors;

import org.eclipse.jface.wizard.Wizard;

import de.bsvrz.buv.plugin.benutzervew.editor.ObjekteWizardPage;
import de.bsvrz.sys.funclib.bitctrl.modell.SystemObjekt;
import de.bsvrz.sys.funclib.bitctrl.modell.att.Attributliste;
import de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AtlAusgeschlosseneObjekte;
import de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AtlEnthalteneObjekte;
import de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AtlObjekte;

/**
 * Assistent zur Bearbeitung einer {@link AtlObjekte}.
 *
 * @author BitCtrl Systems GmbH, ChHoesel
 *
 */
public class ObjekteWizard extends Wizard {

	private MengenBezeichnungWizardPage mengenBezeichnungWizardPage;
	private ObjekteWizardPage objekteWizardPage;
	private Attributliste daten;
	private AtlObjekte objekt;

	public ObjekteWizard(Attributliste daten) {
		setWindowTitle("Objekte Assistent");
		this.daten = daten;
	}

	public ObjekteWizard(AtlObjekte objekt) {
		setWindowTitle("Objekte Assistent");
		this.objekt = objekt;
	}

	@Override
	public void addPages() {
		mengenBezeichnungWizardPage = new MengenBezeichnungWizardPage();
		objekteWizardPage = new ObjekteWizardPage();
		if (objekt != null) {
			objekteWizardPage.setVerwendeteObjekte(
					objekt.getObjekt().stream().map(o -> (SystemObjekt) o).collect(Collectors.toList()));

			mengenBezeichnungWizardPage.setMengenBezeichnung(objekt.getMengenbezeichnung());
		}

		addPage(objekteWizardPage);
		addPage(mengenBezeichnungWizardPage);

	}

	@Override
	public boolean performFinish() {
		if (objekt == null) {
			objekt = new AtlObjekte();

			if (daten instanceof AtlEnthalteneObjekte) {
				((AtlEnthalteneObjekte) daten).getObjekte().add(objekt);
			} else if (daten instanceof AtlAusgeschlosseneObjekte) {
				((AtlAusgeschlosseneObjekte) daten).getObjekte().add(objekt);
			} else {
				throw new IllegalArgumentException(
						"Der Objekte Assistent kann nur die Attributlisten " + AtlEnthalteneObjekte.class.getName()
								+ " & " + AtlAusgeschlosseneObjekte.class.getName() + " verarbeiten.");
			}

		}

		objekt.getObjekt().clear();
		objekt.getObjekt().addAll(objekteWizardPage.getVerwendeteObjekte());

		objekt.setMengenbezeichnung(mengenBezeichnungWizardPage.getMengenBezeichnung());

		return true;
	}

}
