/*
 * Rahmenwerk-Plug-in "Benutzerverwaltung/Zugriffsrechte"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.benutzervew.editor.region;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.editor.FormEditor;

public class RegionEditor extends FormEditor {

	public static final String EDITOR_ID = "de.bsvrz.buv.plugin.benutzervew.region.editor";
	private RegionPage regionPage;

	@Override
	protected void addPages() {

		regionPage = new RegionPage(this, RegionPage.class.getName(), "Region");
		try {
			addPage(regionPage);
		} catch (final PartInitException e) {
			throw new IllegalArgumentException(
					"Der Editor zum Parametrieren der Regionen konnte nicht geöffnet werden.", e);
		}

	}

	@Override
	public void doSave(IProgressMonitor monitor) {
		regionPage.doSave(monitor);
	}

	@Override
	public void doSaveAs() {
		// nüscht
	}

	@Override
	public boolean isSaveAsAllowed() {
		return false;
	}

	@Override
	public void init(IEditorSite site, IEditorInput input) throws PartInitException {
		super.init(site, input);
		setPartName("Region " + getEditorInput().getName());
	}
}
