/*
 * Rahmenwerk-Plug-in "Benutzerverwaltung/Zugriffsrechte"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.benutzervew.editor.region;

import org.eclipse.jface.wizard.Wizard;

import de.bsvrz.buv.plugin.benutzervew.editor.ObjektTypenWizardPage;
import de.bsvrz.buv.plugin.benutzervew.editor.RegionWizardPage;
import de.bsvrz.sys.funclib.bitctrl.modell.att.Attributliste;
import de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AtlAusgeschlosseneObjekte;
import de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AtlEnthalteneObjekte;
import de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AtlRegionen;

/**
 * Assistent für die Parametrierung der {@link AtlRegionen} an einer Region.
 *
 * @author BitCtrl Systems GmbH, ChHoesel
 *
 */
public class RegionWizard extends Wizard {

	private Attributliste daten;
	private AtlRegionen region;
	private RegionWizardPage regionWizardPage;
	private ObjektTypenWizardPage objektTypenWizardPage;
	private MengenBezeichnungWizardPage mengenBezeichnungWizardPage;

	public RegionWizard(Attributliste daten) {
		setWindowTitle("Region Assistent");
		this.daten = daten;
	}

	public RegionWizard(AtlRegionen region) {
		setWindowTitle("Region Assistent");
		this.region = region;
	}

	@Override
	public void addPages() {
		regionWizardPage = new RegionWizardPage();
		objektTypenWizardPage = new ObjektTypenWizardPage();
		mengenBezeichnungWizardPage = new MengenBezeichnungWizardPage();
		if (region != null) {
			regionWizardPage.setVerwendeteRegionen(region.getRegion());
			objektTypenWizardPage.setVerwendeteObjektTypen(region.getTyp());
			mengenBezeichnungWizardPage.setMengenBezeichnung(region.getMengenbezeichnung());
		}
		addPage(regionWizardPage);
		addPage(objektTypenWizardPage);
		addPage(mengenBezeichnungWizardPage);
	}

	@Override
	public boolean performFinish() {
		if (region == null) {
			region = new AtlRegionen();

			if (daten instanceof AtlEnthalteneObjekte) {
				((AtlEnthalteneObjekte) daten).getRegion().add(region);
			} else if (daten instanceof AtlAusgeschlosseneObjekte) {
				((AtlAusgeschlosseneObjekte) daten).getRegion().add(region);
			} else {
				throw new IllegalArgumentException(
						"Der Region Assistent kann nur die Attributlisten " + AtlEnthalteneObjekte.class.getName()
								+ " & " + AtlAusgeschlosseneObjekte.class.getName() + " verarbeiten.");
			}

		}

		region.getRegion().clear();
		region.getRegion().addAll(regionWizardPage.getVerwendeteRegionen());

		region.getTyp().clear();
		region.getTyp().addAll(objektTypenWizardPage.getVerwendeteObjektTypen());

		region.setMengenbezeichnung(mengenBezeichnungWizardPage.getMengenBezeichnung());

		return true;
	}

}
