/*
 * Rahmenwerk-Plug-in "Benutzerverwaltung/Zugriffsrechte"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.benutzervew.editor.rolle;

import org.eclipse.jface.wizard.Wizard;

import de.bsvrz.buv.plugin.benutzervew.editor.AspektWizardPage;
import de.bsvrz.buv.plugin.benutzervew.editor.AttributGruppenWizardPage;
import de.bsvrz.buv.plugin.benutzervew.editor.KonfigurationsbereichWizardPage;
import de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AtlAktivitaetDaten;
import de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.parameter.PdRollenAktivitaet;

/**
 * Wizard zum Erstellen und Bearbeiten der Attributliste "AktivitätDaten" einer
 * Rolle.
 *
 * @author BitCtrl Systems GmbH, ChHoesel
 *
 */
public class AktivitaetDatenWizard extends Wizard {

	private KonfigurationsbereichWizardPage kbPage;
	private AtlAktivitaetDaten aktivitaetDaten;
	private final PdRollenAktivitaet.Daten parameterDaten;
	private AttributGruppenWizardPage atgPage;
	private AspektWizardPage aspPage;
	private AktivitaetDatenWizardPage aktivitaetPage;

	public AktivitaetDatenWizard(PdRollenAktivitaet.Daten daten) {
		setWindowTitle("Aktivitäten Assistent");
		parameterDaten = daten;
	}

	public AktivitaetDatenWizard(PdRollenAktivitaet.Daten daten, final AtlAktivitaetDaten aktivitaetDaten) {
		this(daten);
		this.aktivitaetDaten = aktivitaetDaten;
	}

	@Override
	public void addPages() {
		kbPage = new KonfigurationsbereichWizardPage();
		atgPage = new AttributGruppenWizardPage();
		aspPage = new AspektWizardPage();
		aktivitaetPage = new AktivitaetDatenWizardPage();
		if (aktivitaetDaten != null) {
			kbPage.setVerwendeteKonfigurationsBereiche(aktivitaetDaten.getKonfigurationsbereich());
			atgPage.setVerwendeteAttributGruppen(aktivitaetDaten.getAttributgruppe());
			aspPage.setVerwendeteAspekte(aktivitaetDaten.getAspekt());
			aktivitaetPage.setName(aktivitaetDaten.getName());
			aktivitaetPage.setEmpfaenger(aktivitaetDaten.getEmpfaenger());
			aktivitaetPage.setSender(aktivitaetDaten.getSender());
			aktivitaetPage.setQuelle(aktivitaetDaten.getQuelle());
			aktivitaetPage.setSenke(aktivitaetDaten.getSenke());
		}
		addPage(kbPage);
		addPage(atgPage);
		addPage(aspPage);
		addPage(aktivitaetPage);
	}

	@Override
	public boolean performFinish() {
		if (aktivitaetDaten == null) {
			aktivitaetDaten = new AtlAktivitaetDaten();
			parameterDaten.getAktivitaetDaten().add(aktivitaetDaten);
		}

		aktivitaetDaten.getKonfigurationsbereich().clear();
		aktivitaetDaten.getKonfigurationsbereich().addAll(kbPage.getVerwendeteKonfigurationsBereiche());
		aktivitaetDaten.getAttributgruppe().clear();
		aktivitaetDaten.getAttributgruppe().addAll(atgPage.getVerwendeteAttributgruppen());
		aktivitaetDaten.getAspekt().clear();
		aktivitaetDaten.getAspekt().addAll(aspPage.getVerwendeteAspekte());

		aktivitaetDaten.setName(aktivitaetPage.getName());
		aktivitaetDaten.setEmpfaenger(aktivitaetPage.getEmpfaenger());
		aktivitaetDaten.setSender(aktivitaetPage.getSender());
		aktivitaetDaten.setQuelle(aktivitaetPage.getQuelle());
		aktivitaetDaten.setSenke(aktivitaetPage.getSenke());
		return true;
	}

}
