/*
 * Rahmenwerk-Plug-in "Benutzerverwaltung/Zugriffsrechte"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.benutzervew.editor.rolle;

import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.plugin.AbstractUIPlugin;

import de.bsvrz.buv.plugin.benutzervew.PluginBenutzerVew;
import de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AttJaNeinKeineAussage;

/**
 * {@link WizardPage} zur Auswahl der Attribute über die
 * Sender/Empfänger/Quelle/Senke Beziehung.
 *
 * @author BitCtrl Systems GmbH, ChHoesel
 *
 */
public class AktivitaetDatenWizardPage extends WizardPage {
	private Text txtName;
	private ComboViewer comboViewerSenke;
	private ComboViewer comboViewerQuelle;
	private ComboViewer comboViewerSender;
	private ComboViewer comboViewerEmpfaenger;
	private String name = "aktivität";
	private AttJaNeinKeineAussage empfaenger = AttJaNeinKeineAussage.ZUSTAND_1N_KEINEAUSSAGE;
	private AttJaNeinKeineAussage sender = AttJaNeinKeineAussage.ZUSTAND_1N_KEINEAUSSAGE;
	private AttJaNeinKeineAussage quelle = AttJaNeinKeineAussage.ZUSTAND_1N_KEINEAUSSAGE;
	private AttJaNeinKeineAussage senke = AttJaNeinKeineAussage.ZUSTAND_1N_KEINEAUSSAGE;

	public AktivitaetDatenWizardPage() {
		super(AktivitaetDatenWizardPage.class.getName());
		setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin(PluginBenutzerVew.PLUGIN_ID,
				"icons/aktivitaet_daten_wizrad_page.gif"));
		setTitle("Aktivität Daten");
		setDescription("Beschreibung einer Aktivität.");
	}

	@Override
	public void createControl(Composite parent) {
		final Composite container = new Composite(parent, SWT.NONE);

		setControl(container);
		container.setLayout(new GridLayout(2, false));

		final Label lblName = new Label(container, SWT.NONE);
		lblName.setText("Name:");

		txtName = new Text(container, SWT.BORDER);
		txtName.setToolTipText("Beschreibender Name dieser Aktivität.");
		if (name != null) {
			txtName.setText(name);
		} else {
			txtName.setText("aktivität");
		}
		txtName.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));

		final Label lblEmpfnger = new Label(container, SWT.NONE);
		lblEmpfnger.setText("Empfänger:");

		comboViewerEmpfaenger = new ComboViewer(container, SWT.READ_ONLY);
		comboViewerEmpfaenger.setContentProvider(ArrayContentProvider.getInstance());
		comboViewerEmpfaenger.setInput(AttJaNeinKeineAussage.getZustaende());

		comboViewerEmpfaenger.setSelection(new StructuredSelection(empfaenger));
		final Combo comboEmpfaenger = comboViewerEmpfaenger.getCombo();
		comboEmpfaenger.setToolTipText("Gibt an, ob die Daten mit diesen Rechte empfangen (gelesen) werden dürfen.");
		comboEmpfaenger.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));

		final Label lblSender = new Label(container, SWT.NONE);
		lblSender.setText("Sender:");

		comboViewerSender = new ComboViewer(container, SWT.READ_ONLY);
		comboViewerSender.setContentProvider(ArrayContentProvider.getInstance());
		comboViewerSender.setInput(AttJaNeinKeineAussage.getZustaende());

		comboViewerSender.setSelection(new StructuredSelection(sender));
		final Combo comboSender = comboViewerSender.getCombo();
		comboSender.setToolTipText("Gibt an, ob die Daten mit diesen Rechte gesendet (geschrieben) werden dürfen.");
		comboSender.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));

		final Label lblQuelle = new Label(container, SWT.NONE);
		lblQuelle.setText("Quelle:");

		comboViewerQuelle = new ComboViewer(container, SWT.READ_ONLY);
		comboViewerQuelle.setContentProvider(ArrayContentProvider.getInstance());
		comboViewerQuelle.setInput(AttJaNeinKeineAussage.getZustaende());

		comboViewerQuelle.setSelection(new StructuredSelection(quelle));
		final Combo comboQuelle = comboViewerQuelle.getCombo();
		comboQuelle.setToolTipText("Gibt an, ob die Daten mit diesen Rechte als Quelle angemeldet werden dürfen.");
		comboQuelle.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));

		final Label lblSenke = new Label(container, SWT.NONE);
		lblSenke.setText("Senke:");

		comboViewerSenke = new ComboViewer(container, SWT.READ_ONLY);
		comboViewerSenke.setContentProvider(ArrayContentProvider.getInstance());
		comboViewerSenke.setInput(AttJaNeinKeineAussage.getZustaende());
		comboViewerSenke.setSelection(new StructuredSelection(senke));
		final Combo comboSenke = comboViewerSenke.getCombo();
		comboSenke.setToolTipText("Gibt an, ob die Daten mit diesen Rechte als Senke angemeldet werden dürfen.");
		comboSenke.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		comboSenke.select(2);
	}

	public void setName(final String name) {
		this.name = name;
	}

	@Override
	public String getName() {
		return txtName.getText();
	}

	public void setEmpfaenger(final AttJaNeinKeineAussage value) {
		this.empfaenger = value;
	}

	public AttJaNeinKeineAussage getEmpfaenger() {
		return (AttJaNeinKeineAussage) ((IStructuredSelection) comboViewerEmpfaenger.getSelection()).getFirstElement();
	}

	public void setSender(final AttJaNeinKeineAussage value) {
		this.sender = value;
	}

	public AttJaNeinKeineAussage getSender() {
		return (AttJaNeinKeineAussage) ((IStructuredSelection) comboViewerSender.getSelection()).getFirstElement();
	}

	public void setQuelle(final AttJaNeinKeineAussage value) {
		this.quelle = value;
	}

	public AttJaNeinKeineAussage getQuelle() {
		return (AttJaNeinKeineAussage) ((IStructuredSelection) comboViewerQuelle.getSelection()).getFirstElement();
	}

	public void setSenke(final AttJaNeinKeineAussage value) {
		this.senke = value;
	}

	public AttJaNeinKeineAussage getSenke() {
		return (AttJaNeinKeineAussage) ((IStructuredSelection) comboViewerSenke.getSelection()).getFirstElement();
	}
}
