/*
 * Rahmenwerk-Plug-in "Benutzerverwaltung/Zugriffsrechte"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.benutzervew.editor.rolle;

import org.eclipse.jface.wizard.Wizard;

import de.bsvrz.buv.plugin.benutzervew.editor.KonfigurationsbereichWizardPage;
import de.bsvrz.buv.plugin.benutzervew.editor.MengenTypWizardPage;
import de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein;
import de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AtlAktivitaetMengen;
import de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.parameter.PdRollenAktivitaet;
import de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.parameter.PdRollenAktivitaet.Daten;

/**
 * Assistent zur Parametrierung der {@link AtlAktivitaetMengen} einer Rolle
 * (neu).
 *
 * @author BitCtrl Systems GmbH, ChHoesel
 *
 */
public class AktivitaetMengenWizard extends Wizard {

	private final Daten daten;
	private AtlAktivitaetMengen mengen;
	private KonfigurationsbereichWizardPage konfigurationsbereichWizardPage;
	private MengenTypWizardPage mengenTypWizardPage;
	private AktivitaetMengenWizardPage aktivitaetMengenWizardPage;

	public AktivitaetMengenWizard(PdRollenAktivitaet.Daten daten) {
		setWindowTitle(AktivitaetMengenWizard.class.getName());
		this.daten = daten;
	}

	public AktivitaetMengenWizard(PdRollenAktivitaet.Daten daten, AtlAktivitaetMengen mengen) {
		this(daten);
		this.mengen = mengen;
	}

	@Override
	public void addPages() {
		mengenTypWizardPage = new MengenTypWizardPage();

		konfigurationsbereichWizardPage = new KonfigurationsbereichWizardPage();

		aktivitaetMengenWizardPage = new AktivitaetMengenWizardPage();
		if (mengen != null) {
			konfigurationsbereichWizardPage.setVerwendeteKonfigurationsBereiche(mengen.getKonfigurationsbereich());
			mengenTypWizardPage.setVerwendeteMengenTypen(mengen.getMengentyp());
			aktivitaetMengenWizardPage.setMengeAendern(mengen.getMengeAendern().equals(AttJaNein.ZUSTAND_1_JA));
		}
		addPage(mengenTypWizardPage);
		addPage(konfigurationsbereichWizardPage);
		addPage(aktivitaetMengenWizardPage);
	}

	@Override
	public boolean performFinish() {
		if (mengen == null) {
			mengen = new AtlAktivitaetMengen();
			daten.getAktivitaetMengen().add(mengen);
		}

		mengen.getKonfigurationsbereich().clear();
		mengen.getKonfigurationsbereich().addAll(konfigurationsbereichWizardPage.getVerwendeteKonfigurationsBereiche());

		mengen.getMengentyp().clear();
		mengen.getMengentyp().addAll(mengenTypWizardPage.getVerwendeteMengenTypen());

		mengen.setMengeAendern(
				aktivitaetMengenWizardPage.isMengeAendern() ? AttJaNein.ZUSTAND_1_JA : AttJaNein.ZUSTAND_0_NEIN);

		return true;
	}

}
