/*
 * Rahmenwerk-Plug-in "Benutzerverwaltung/Zugriffsrechte"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.benutzervew.editor.rolle;

import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.plugin.AbstractUIPlugin;

import de.bsvrz.buv.plugin.benutzervew.PluginBenutzerVew;

/**
 * {@link WizardPage} für Parameterierung, ob Mengen geändert werden dürfen.
 *
 * @author BitCtrl Systems GmbH, ChHoesel
 *
 */
public class AktivitaetMengenWizardPage extends WizardPage {

	private Button button;

	private boolean mengeAendern;

	public AktivitaetMengenWizardPage() {
		super(AktivitaetMengenWizardPage.class.getName());
		setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin(PluginBenutzerVew.PLUGIN_ID,
				"icons/aktivitaet_mengen_wizrad_page.gif"));
		setTitle("Aktivität Mengen");
		setDescription("Gibt die Operationen an, die mit den gewählten Mengentypen ausgführt werden dürfen.");
	}

	@Override
	public void createControl(Composite parent) {
		final Composite container = new Composite(parent, SWT.NONE);

		setControl(container);
		container.setLayout(new GridLayout(2, false));

		final Label lblMengenndern = new Label(container, SWT.NONE);
		lblMengenndern.setText("Mengen ändern:");

		button = new Button(container, SWT.CHECK);
		button.setToolTipText("Gibt an, ob zu den spezifizierten Mengentypen Mengen geändert werden dürfen.");
		button.setSelection(mengeAendern);
	}

	public boolean isMengeAendern() {
		return button.getSelection();
	}

	public void setMengeAendern(boolean mengeAendern) {
		this.mengeAendern = mengeAendern;
	}
}
