/*
 * Rahmenwerk-Plug-in "Benutzerverwaltung/Zugriffsrechte"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.benutzervew.editor.rolle;

import org.eclipse.jface.wizard.Wizard;

import de.bsvrz.buv.plugin.benutzervew.editor.KonfigurationsbereichWizardPage;
import de.bsvrz.buv.plugin.benutzervew.editor.ObjektTypenWizardPage;
import de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein;
import de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AtlAktivitaetObjekteNeu;
import de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.parameter.PdRollenAktivitaet;
import de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.parameter.PdRollenAktivitaet.Daten;

/**
 * Assistent zur Parametrierung der {@link AtlAktivitaetObjekteNeu} einer
 * Rolle(neu).
 *
 * @author BitCtrl Systems GmbH, ChHoesel
 *
 */
public class AktivitaetObjekteWizard extends Wizard {

	private AtlAktivitaetObjekteNeu aktivitaetObjekte;
	private final Daten daten;
	private KonfigurationsbereichWizardPage kbPage;
	private ObjektTypenWizardPage typenWizardPage;
	private AktivitaetObjekteWizardPage aktivitaetObjekteWizardPage;

	public AktivitaetObjekteWizard(PdRollenAktivitaet.Daten daten) {
		setWindowTitle("Rolle-Objekte Assistent");
		this.daten = daten;

	}

	public AktivitaetObjekteWizard(PdRollenAktivitaet.Daten daten, final AtlAktivitaetObjekteNeu aktivitaetObjekte) {
		this(daten);
		this.aktivitaetObjekte = aktivitaetObjekte;
	}

	@Override
	public void addPages() {
		kbPage = new KonfigurationsbereichWizardPage();
		typenWizardPage = new ObjektTypenWizardPage();
		aktivitaetObjekteWizardPage = new AktivitaetObjekteWizardPage();
		if (aktivitaetObjekte != null) {
			kbPage.setVerwendeteKonfigurationsBereiche(aktivitaetObjekte.getKonfigurationsbereich());
			typenWizardPage.setVerwendeteObjektTypen(aktivitaetObjekte.getObjekttyp());
			aktivitaetObjekteWizardPage.setErzeugenAendernLoeschen(
					AttJaNein.ZUSTAND_1_JA.equals(aktivitaetObjekte.getObjekteErzeugenAendernLoeschen()));
		}

		addPage(kbPage);
		addPage(typenWizardPage);
		addPage(aktivitaetObjekteWizardPage);
	}

	@Override
	public boolean performFinish() {
		if (aktivitaetObjekte == null) {
			aktivitaetObjekte = new AtlAktivitaetObjekteNeu();
			daten.getAktivitaetObjekte().add(aktivitaetObjekte);
		}

		aktivitaetObjekte.getKonfigurationsbereich().clear();
		aktivitaetObjekte.getKonfigurationsbereich().addAll(kbPage.getVerwendeteKonfigurationsBereiche());

		aktivitaetObjekte.getObjekttyp().clear();
		aktivitaetObjekte.getObjekttyp().addAll(typenWizardPage.getVerwendeteObjektTypen());

		aktivitaetObjekte.setObjekteErzeugenAendernLoeschen(
				aktivitaetObjekteWizardPage.isErzeugenAendernLoeschen() ? AttJaNein.ZUSTAND_1_JA
						: AttJaNein.ZUSTAND_0_NEIN);

		return true;
	}

}
