/*
 * Rahmenwerk-Plug-in "Benutzerverwaltung/Zugriffsrechte"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.buv.plugin.benutzervew.handler;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

import de.bsvrz.buv.plugin.benutzervew.data.Benutzer;
import de.bsvrz.buv.plugin.benutzervew.internal.RahmenwerkService;
import de.bsvrz.dav.daf.main.config.ConfigurationTaskException;
import de.bsvrz.dav.daf.main.config.management.UserAdministration;

/**
 * Handler für das Kommando zum Anzeigen der nicht benutzten Einmalpassworte
 * eines Benutzers. <br>
 * (Die Funktion wird zur Zeit von der DAV-API nicht unterst&uuml;tzt. Deshalb
 * immer deaktiviert.)
 *
 * @author BitCtrl Systems GmbH, Steffen Gieseler
 */
public class BenutzerEinmalPassworteAnzeigenHandler extends AbstractHandler {

	public static final String COMMAND_ID = "de.bsvrz.buv.plugin.benutzervew.actions.BenutzerEinmalPassworteAnzeigenAktion";

	@Override
	public Object execute(final ExecutionEvent event) throws ExecutionException {

		final Benutzer benutzer = getBenutzer(event);
		if (benutzer != null) {
			final UserAdministration userAdministration = RahmenwerkService.getService().getRahmenWerk()
					.getDavVerbindung().getDataModel().getUserAdministration();
			try {
				final int[] singleServingPasswordId = userAdministration.getValidOneTimePasswordIDs(
						RahmenwerkService.getService().getRahmenWerk().getBenutzerName(),
						RahmenwerkService.getService().getRahmenWerk().getPasswort(), benutzer.getName());

				final StringBuilder message = new StringBuilder(200);
				if (singleServingPasswordId.length > 0) {
					message.append("Für den Benutzer '");
					message.append(benutzer.getName());
					message.append("' sind noch ");
					message.append(singleServingPasswordId.length);
					message.append(" Einmal-Passworte verfügbar\n");

					message.append("Verfügbar sind die ID: ");
					for (int idx = 0; idx < singleServingPasswordId.length; idx++) {
						if (idx > 0) {
							message.append(',');
						}
						message.append(singleServingPasswordId[idx]);
					}
				} else {
					message.append("Für den Benutzer '");
					message.append(benutzer.getName());
					message.append("' sind keine Einmal-Passworte verfügbar");
				}

				MessageDialog.openInformation(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(),
						"Einmal-Passworte", message.toString());

			} catch (final ConfigurationTaskException e) {
				MessageDialog.openInformation(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "FEHLER",
						"Informationen zu Einmal-Passworten konnte nicht ermittelt werden!\n"
								+ e.getLocalizedMessage());
			}
		}

		return null;
	}

	private Benutzer getBenutzer(final ExecutionEvent event) {
		final ISelection selection = HandlerUtil.getCurrentSelection(event);
		if (selection instanceof IStructuredSelection) {
			final Object benutzer = ((IStructuredSelection) selection).getFirstElement();
			if (benutzer instanceof Benutzer) {
				return (Benutzer) benutzer;
			}
		}

		return null;
	}
}
