/*
 * Rahmenwerk-Plug-in "Benutzerverwaltung/Zugriffsrechte"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.buv.plugin.benutzervew.handler;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;

import de.bsvrz.buv.plugin.benutzervew.views.BenutzerListe;
import de.bsvrz.sys.funclib.debug.Debug;

/**
 * Handler für das Kommando zum &Ouml;ffnen der Ansicht 'Benutzer und
 * Berechtigungsklassen'.
 *
 * @author BitCtrl Systems GmbH, Steffen Gieseler
 */
public class BenutzerListeOeffnenHandler extends AbstractHandler {

	/** Debug-Logger. */
	private final Debug log = Debug.getLogger();

	@Override
	public Object execute(final ExecutionEvent event) throws ExecutionException {
		final IWorkbenchWindow dw = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
		final IWorkbenchPage page = dw.getActivePage();

		try {
			page.showView(BenutzerListe.class.getName());
		} catch (final WorkbenchException e) {
			log.error("", e);
		}
		return null;
	}

}
