/*
 * Rahmenwerk-Plug-in "Benutzerverwaltung/Zugriffsrechte"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.buv.plugin.benutzervew.handler;

import java.util.ResourceBundle;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.Window;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.handlers.HandlerUtil;

import de.bsvrz.buv.plugin.benutzervew.PluginBenutzerVew;
import de.bsvrz.buv.plugin.benutzervew.data.Benutzer;
import de.bsvrz.buv.plugin.benutzervew.data.Benutzerverwaltung;
import de.bsvrz.buv.plugin.benutzervew.internal.RahmenwerkService;
import de.bsvrz.buv.plugin.benutzervew.wizards.BenutzerPasswortWizard;

/**
 * Handler für das Kommando zum &Auml;ndern des Passwortes eines Benutzers. Wenn
 * kein Benutzer ausgw&auml;hlt ist, wird das Passwort des angemeldeten
 * Benutzers ge&auml;ndert.
 *
 * @author BitCtrl Systems GmbH, Steffen Gieseler
 */
public class BenutzerPasswortAendernHandler extends BmvAdminHandler {

	public static final String COMMAND_ID = "de.bsvrz.buv.plugin.benutzervew.actions.BenutzerPasswortAendernAktion";

	@Override
	public Object execute(final ExecutionEvent event) throws ExecutionException {

		final ResourceBundle ressourcebundle = PluginBenutzerVew.getDefault().getResourceBundle();
		final Benutzer benutzer = getBenutzer(event);
		final Benutzerverwaltung bv = RahmenwerkService.getService().getBenutzerverwaltung();

		if ((benutzer != bv.getAngemeldetenBenutzer()) && (!testeAdmin())) {
			return null;
		}

		final BenutzerPasswortWizard wizard = new BenutzerPasswortWizard(benutzer);

		final WizardDialog dialog = new WizardDialog(Display.getDefault().getActiveShell(), wizard);
		if (dialog.open() == Window.OK) {

			if (benutzer == bv.getAngemeldetenBenutzer()) {
				MessageDialog.openInformation(Display.getDefault().getActiveShell(),
						ressourcebundle.getString("PasswortHinweis.title"),
						ressourcebundle.getString("PasswortHinweisEigenesPasswort.text"));
			} else {
				if (bv.getAnmeldungen(benutzer).size() > 0) {
					MessageDialog.openInformation(Display.getDefault().getActiveShell(),
							ressourcebundle.getString("PasswortHinweis.title"), "Der Benutzer '" + benutzer.getName()
									+ "' ist z. Zt. angemeldet.\nEr sollte über das geänderte Passwort informiert werden!");
				}
			}
		}
		return null;
	}

	private Benutzer getBenutzer(final ExecutionEvent event) {

		final ISelection selection = HandlerUtil.getCurrentSelection(event);
		if (selection instanceof IStructuredSelection) {
			final Object benutzer = ((IStructuredSelection) selection).getFirstElement();
			if (benutzer instanceof Benutzer) {
				return (Benutzer) benutzer;
			}
		}

		return null;
	}

}
