/*
 * Rahmenwerk-Plug-in "Benutzerverwaltung/Zugriffsrechte"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.buv.plugin.benutzervew.handler;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

import de.bsvrz.buv.plugin.benutzervew.data.Benutzer;
import de.bsvrz.buv.plugin.benutzervew.internal.RahmenwerkService;
import de.bsvrz.dav.daf.main.ClientDavInterface;
import de.bsvrz.dav.daf.main.config.ConfigurationTaskException;
import de.bsvrz.dav.daf.main.config.DataModel;
import de.bsvrz.dav.daf.main.config.management.UserAdministration;

/**
 * Hanlder für das Kommando zum L&ouml;schen der Einmalpassworte eines
 * Benutzers. <br>
 * (Die Funktion wird zur Zeit von der DAV-API nicht unterst&uuml;tzt.)
 *
 * @author BitCtrl Systems GmbH, Steffen Gieseler
 */
public class BenutzerPassworteLoeschenHandler extends AbstractHandler {

	public static final String COMMAND_ID = "de.bsvrz.buv.plugin.benutzervew.actions.BenutzerPassworteLoeschenAktion";

	@Override
	public Object execute(final ExecutionEvent event) throws ExecutionException {

		final Benutzer benutzer = getBenutzer(event);

		if (benutzer != null) {
			final Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
			if (MessageDialog.openQuestion(shell, "Löschen Einmalpassworte Benutzer",
					"Sollen die Einmalpassworte des Benutzers: " + System.getProperty("line.separator") + benutzer
							+ System.getProperty("line.separator") + "wirklich gelöscht werden?")) {

				final ClientDavInterface dav = RahmenwerkService.getService().getRahmenWerk().getDavVerbindung();
				if (dav != null) {
					final DataModel modell = dav.getDataModel();
					final UserAdministration userAdmin = modell.getUserAdministration();
					try {
						userAdmin.clearSingleServingPasswords(
								RahmenwerkService.getService().getRahmenWerk().getBenutzerName(),
								RahmenwerkService.getService().getRahmenWerk().getPasswort(), benutzer.getName());
					} catch (final ConfigurationTaskException e) {
						MessageDialog.openError(shell, "FEHLER", "Das Löschen der Einmalpassworte für den Benutzer "
								+ benutzer.getName() + " ist fehlgeschlagen!\n" + e.getLocalizedMessage());
					}
				}
			}
		}
		return null;
	}

	private Benutzer getBenutzer(final ExecutionEvent event) {

		final ISelection selection = HandlerUtil.getCurrentSelection(event);
		if (selection instanceof IStructuredSelection) {
			final Object benutzer = ((IStructuredSelection) selection).getFirstElement();
			if (benutzer instanceof Benutzer) {
				return (Benutzer) benutzer;
			}
		}

		return null;
	}
}
