/*
 * Rahmenwerk-Plug-in "Benutzerverwaltung/Zugriffsrechte"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.buv.plugin.benutzervew.handler;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.handlers.HandlerUtil;

import de.bsvrz.buv.plugin.benutzervew.data.Benutzer;
import de.bsvrz.buv.plugin.benutzervew.wizards.BenutzerBearbeitenWizard;

/**
 * Handler für das Kommando zum Bearbeiten der Berechtigungen eines Benutzers.
 *
 * @author BitCtrl Systems GmbH, Steffen Gieseler
 */
public class BenutzerRechteBearbeitenHandler extends BmvAdminHandler {

	public static final String COMMAND_ID = "de.bsvrz.buv.plugin.benutzervew.actions.BenutzerRechteBearbeitenAktion";

	@Override
	public Object execute(final ExecutionEvent event) throws ExecutionException {

		if (!testeAdmin()) {
			return null;
		}

		final Benutzer benutzer = getBenutzer(event);
		if (benutzer == null) {
			return null;
		}

		final BenutzerBearbeitenWizard wizard = new BenutzerBearbeitenWizard(benutzer);
		final WizardDialog dialog = new WizardDialog(Display.getDefault().getActiveShell(), wizard);
		dialog.open();
		return null;
	}

	private Benutzer getBenutzer(final ExecutionEvent event) {
		final ISelection selection = HandlerUtil.getCurrentSelection(event);
		if (selection instanceof IStructuredSelection) {
			final Object benutzer = ((IStructuredSelection) selection).getFirstElement();
			if (benutzer instanceof Benutzer) {
				return (Benutzer) benutzer;
			}
		}

		return null;
	}

}
