/*
 * Rahmenwerk-Plug-in "Benutzerverwaltung/Zugriffsrechte"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.buv.plugin.benutzervew.handler;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.handlers.HandlerUtil;

import de.bsvrz.buv.plugin.benutzervew.data.BerechtigungsKlasse;
import de.bsvrz.buv.plugin.benutzervew.wizards.BerechtigungsklasseWizard;

/**
 * Handler für das Kommando zum Bearbeiten einer Berechtigungsklasse.
 *
 * @author BitCtrl Systems GmbH, Steffen Gieseler
 */
public class BerechtigungsklasseBearbeitenHandler extends BmvAdminHandler {

	public static final String COMMAND_ID = "de.bsvrz.buv.plugin.benutzervew.actions.BerechtigungsklasseBearbeitenAktion";

	@Override
	public Object execute(final ExecutionEvent event) throws ExecutionException {

		// soll entsprechend Absprache mit Herrn Bräuner nur als
		// Administrator möglich sein
		if (!testeAdmin()) {
			return null;
		}

		final BerechtigungsKlasse klasse = getBerechtigungsklasse(event);
		if (klasse == null) {
			return null;
		}

		final BerechtigungsklasseWizard wizard = new BerechtigungsklasseWizard(klasse);
		final WizardDialog dialog = new WizardDialog(Display.getDefault().getActiveShell(), wizard);
		dialog.open();
		return null;
	}

	private BerechtigungsKlasse getBerechtigungsklasse(final ExecutionEvent event) {
		final ISelection selection = HandlerUtil.getCurrentSelection(event);
		if (selection instanceof IStructuredSelection) {
			final Object klasse = ((IStructuredSelection) selection).getFirstElement();
			if (klasse instanceof BerechtigungsKlasse) {
				return (BerechtigungsKlasse) klasse;
			}
		}

		return null;
	}

}
