/*
 * Rahmenwerk-Plug-in "Benutzerverwaltung/Zugriffsrechte"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.benutzervew.handler;

import java.util.ResourceBundle;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;

import de.bsvrz.buv.plugin.benutzervew.PluginBenutzerVew;
import de.bsvrz.buv.plugin.benutzervew.data.Benutzerverwaltung;
import de.bsvrz.buv.plugin.benutzervew.internal.RahmenwerkService;

public abstract class BmvAdminHandler extends AbstractHandler {

	/**
	 * Testet, ob der aktuell angemeldete Benutzer Administrator-Rechte besitzt.
	 *
	 * @return true wenn Administrator, sonst false
	 */
	protected boolean testeAdmin() {
		final Benutzerverwaltung bv = RahmenwerkService.getService().getBenutzerverwaltung();

		if (!bv.isDAVAdmin(RahmenwerkService.getService().getRahmenWerk().getBenutzerName(),
				RahmenwerkService.getService().getRahmenWerk().getPasswort())) {
			final ResourceBundle ressourcebundle = PluginBenutzerVew.getDefault().getResourceBundle();
			MessageDialog.openInformation(Display.getDefault().getActiveShell(), "Hinweis",
					ressourcebundle.getString("NichtAusreichendRechte.text"));
			return false;
		}

		return true;
	}
}
