/*
 * Rahmenwerk-Plug-in "Benutzerverwaltung/Zugriffsrechte"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.buv.plugin.benutzervew.views;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.eclipse.jface.action.IMenuListener2;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.menus.CommandContributionItemParameter;

import de.bsvrz.buv.plugin.benutzervew.actions.ViewAktualisierenAktion;
import de.bsvrz.buv.plugin.benutzervew.data.Benutzer;
import de.bsvrz.buv.plugin.benutzervew.data.BerechtigungsKlasse;
import de.bsvrz.buv.plugin.benutzervew.handler.BenutzerAnlegenHandler;
import de.bsvrz.buv.plugin.benutzervew.handler.BenutzerEinmalPassworteAnzeigenHandler;
import de.bsvrz.buv.plugin.benutzervew.handler.BenutzerLoeschenHandler;
import de.bsvrz.buv.plugin.benutzervew.handler.BenutzerPasswortAendernHandler;
import de.bsvrz.buv.plugin.benutzervew.handler.BenutzerPassworteLoeschenHandler;
import de.bsvrz.buv.plugin.benutzervew.handler.BenutzerRechteBearbeitenHandler;
import de.bsvrz.buv.plugin.benutzervew.handler.BerechtigungsklasseBearbeitenHandler;

/**
 * Kontextmen&uuml; f&uuml;r Benutzer-/Zugriffsrechte-View.
 *
 * @author BitCtrl Systems GmbH, Steffen Gieseler
 *
 */
public class BenutzerContextMenu extends MenuManager {

	/**
	 * das ausgew&auml;hlte Object.
	 */

	private Object selectedObject;

	/**
	 * der View.
	 */
	private final StructuredViewer view;

	/**
	 * Standardkonstruktor.
	 *
	 * @param viewer Viewer, in dem sich das Element befindet
	 */
	public BenutzerContextMenu(final StructuredViewer viewer) {
		super();
		this.view = viewer;
		setRemoveAllWhenShown(true);

		addMenuListener(new IMenuListener2() {
			@Override
			public void menuAboutToHide(final IMenuManager manager) {
				deRegisterMenu(manager);
			}

			@Override
			public void menuAboutToShow(final IMenuManager mgr) {
				fillContextMenu(mgr);
			}
		});
	}

	/**
	 * Konstruktor.
	 *
	 * @param object das Objekt, f&uuml;r dass dieses Kontextmen&uuml; ge&ouml;ffnet
	 *               werden soll.
	 */
	// das Objekt, für dass dieses Kontextmenü ausgehen soll.
	// public BenutzerNavigatorContextMenu(final Object object) {
	// super();
	// selectedObject = object;
	// setRemoveAllWhenShown(true);
	// addMenuListener(new IMenuListener2() {
	// public void menuAboutToHide(final IMenuManager manager) {
	// deRegisterMenu(manager);
	// }
	//
	// public void menuAboutToShow(final IMenuManager mgr) {
	// fillContextMenu(mgr);
	// }
	// });
	// }

	/**
	 * entfernt alle Registrierungen der Aktionen des Menüs im Rahmenwerk.
	 *
	 * @param manager der Menümanager
	 */
	void deRegisterMenu(final IMenuManager manager) {
		// for (IContributionItem item : manager.getItems()) {
		// if (item instanceof ActionContributionItem) {
		// if (((ActionContributionItem) item).getAction() instanceof
		// PuAPluginAktion) {
		// ((PuAPluginAktion) ((ActionContributionItem) item)
		// .getAction()).dispose();
		// }
		// }
		// }
	}

	/**
	 * Füllt dieses Kontextmenü mit allen Punkten, die für dieses AbstractDavObject
	 * zur Verfügung gestellt werden können.
	 *
	 * @param mgr - der Menümanager.
	 */
	void fillContextMenu(final IMenuManager mgr) {

		final List<Object> selected = new ArrayList<>();

		if (view != null) {
			final ISelection viewerSelection = view.getSelection();

			if (viewerSelection instanceof IStructuredSelection) {
				final IStructuredSelection selection = (IStructuredSelection) viewerSelection;
				selectedObject = selection.getFirstElement();
				final Iterator<Object> iterator = selection.iterator();
				while (iterator.hasNext()) {
					selected.add(iterator.next());
				}
			}
		}

		if (selected.isEmpty() && (selectedObject != null)) {
			selected.add(selectedObject);
		}

		if (selectedObject instanceof Benutzer) {
			fillContextMenuBenutzer(mgr);
		} else if (selectedObject instanceof BerechtigungsKlasse) {
			fillContextMenuBerechtigungsklasse(mgr);
		}
	}

	/**
	 * Erzeugt das Kontext-Men&uuml; für eine Berechtigungsklasse.
	 *
	 * @param mgr IMenuManager
	 */
	private void fillContextMenuBerechtigungsklasse(final IMenuManager mgr) {

		CommandContributionItemParameter parameter = new CommandContributionItemParameter(
				PlatformUI.getWorkbench().getActiveWorkbenchWindow(), null,
				BerechtigungsklasseBearbeitenHandler.COMMAND_ID, CommandContributionItem.STYLE_PUSH);
		mgr.add(new CommandContributionItem(parameter));

		mgr.add(new Separator());

		parameter = new CommandContributionItemParameter(PlatformUI.getWorkbench().getActiveWorkbenchWindow(), null,
				BenutzerAnlegenHandler.COMMAND_ID, CommandContributionItem.STYLE_PUSH);
		mgr.add(new CommandContributionItem(parameter));

		mgr.add(new Separator());
		mgr.add(new ViewAktualisierenAktion(view));
		mgr.setVisible(true);

	}

	/**
	 * Erzeugt das Kontext-Men&uuml; für einen Benutzer.
	 *
	 * @param mgr IMenuManager
	 */
	private void fillContextMenuBenutzer(final IMenuManager mgr) {
		CommandContributionItemParameter parameter = new CommandContributionItemParameter(
				PlatformUI.getWorkbench().getActiveWorkbenchWindow(), null, BenutzerRechteBearbeitenHandler.COMMAND_ID,
				CommandContributionItem.STYLE_PUSH);
		mgr.add(new CommandContributionItem(parameter));

		parameter = new CommandContributionItemParameter(PlatformUI.getWorkbench().getActiveWorkbenchWindow(), null,
				BenutzerLoeschenHandler.COMMAND_ID, CommandContributionItem.STYLE_PUSH);
		mgr.add(new CommandContributionItem(parameter));

		mgr.add(new Separator());

		parameter = new CommandContributionItemParameter(PlatformUI.getWorkbench().getActiveWorkbenchWindow(), null,
				BenutzerPasswortAendernHandler.COMMAND_ID, CommandContributionItem.STYLE_PUSH);
		mgr.add(new CommandContributionItem(parameter));

		parameter = new CommandContributionItemParameter(PlatformUI.getWorkbench().getActiveWorkbenchWindow(), null,
				BenutzerPassworteLoeschenHandler.COMMAND_ID, CommandContributionItem.STYLE_PUSH);
		mgr.add(new CommandContributionItem(parameter));

		parameter = new CommandContributionItemParameter(PlatformUI.getWorkbench().getActiveWorkbenchWindow(), null,
				BenutzerEinmalPassworteAnzeigenHandler.COMMAND_ID, CommandContributionItem.STYLE_PUSH);
		mgr.add(new CommandContributionItem(parameter));

		mgr.add(new Separator());
		mgr.add(new ViewAktualisierenAktion(view));
		mgr.setVisible(true);
	}
}
