/*
 * Rahmenwerk-Plug-in "Benutzerverwaltung/Zugriffsrechte"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.buv.plugin.benutzervew.views;

import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

import de.bsvrz.buv.plugin.benutzervew.data.Benutzer;
import de.bsvrz.buv.plugin.benutzervew.views.BenutzerListe.SpaltenIndex;

/**
 * Label-Provider f&uuml; die Benutzerliste.
 *
 * @author BitCtrl Systems GmbH, Steffen Gieseler
 */
public class BenutzerListeLabelProvider extends LabelProvider implements ITableLabelProvider {

	@Override
	public Image getColumnImage(final Object element, final int columnIndex) {
		return null;
	}

	@Override
	public String getColumnText(final Object element, final int columnIndex) {
		String text = null;

		final Benutzer b = (Benutzer) element;

		if (columnIndex == SpaltenIndex.valueOf(SpaltenIndex.SPALTE_KENNUNG.name()).ordinal()) {
			text = b.getName();
		} else if (columnIndex == SpaltenIndex.valueOf(SpaltenIndex.SPALTE_BENUTZERKLASSE.name()).ordinal()) {
			final String bkl = b.getBerechtigungsKlassenAsString();
			if (bkl.isEmpty()) {
				text = "-";
			} else {
				text = bkl;
			}
		} else if (columnIndex == SpaltenIndex.valueOf(SpaltenIndex.SPALTE_NAME.name()).ordinal()) {
			if (b.getNachname().isEmpty()) {
				text = "-";
			} else {
				text = b.getNachname();
			}
		} else if (columnIndex == SpaltenIndex.valueOf(SpaltenIndex.SPALTE_VORNAME.name()).ordinal()) {
			if (b.getVorname().isEmpty()) {
				text = "-";
			} else {
				text = b.getVorname();
			}
		} else if (columnIndex == SpaltenIndex.valueOf(SpaltenIndex.SPALTE_ZWEITERVORNAME.name()).ordinal()) {
			if (b.getZweiterVorname().isEmpty()) {
				text = "-";
			} else {
				text = b.getZweiterVorname();
			}
		} else if (columnIndex == SpaltenIndex.valueOf(SpaltenIndex.SPALTE_ORGANISATION.name()).ordinal()) {
			if (b.getOrganisation().isEmpty()) {
				text = "-";
			} else {
				text = b.getOrganisation();
			}
		} else if (columnIndex == SpaltenIndex.valueOf(SpaltenIndex.SPALTE_EMAIL.name()).ordinal()) {
			if (b.getEmailAdresse().isEmpty()) {
				text = "-";
			} else {
				text = b.getEmailAdresse();
			}
		} else {
			text = "";
		}

		return text;
	}
}
