/*
 * Rahmenwerk-Plug-in "Benutzerverwaltung/Zugriffsrechte"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.buv.plugin.benutzervew.views;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Color;

import de.bsvrz.buv.plugin.benutzervew.data.Benutzerverwaltung;
import de.bsvrz.buv.plugin.benutzervew.data.BerechtigungsKlasse;
import de.bsvrz.buv.plugin.benutzervew.internal.RahmenwerkService;

/**
 * Content-Provider f&uuml;r Navigator.
 *
 * @author BitCtrl Systems GmbH, Steffen Gieseler
 */
public class BenutzerNavigatorContentProvider extends LabelProvider implements ITreeContentProvider, IColorProvider {

	@Override
	public Object[] getChildren(final Object parentElement) {
		final Collection<Object> result = new ArrayList<>();

		if (parentElement instanceof Benutzerverwaltung) {
			return ((Benutzerverwaltung) parentElement).getBerechtigungsKlassen().toArray();
		}
		if (parentElement instanceof BerechtigungsKlasse) {
			final BerechtigungsKlasse klasse = (BerechtigungsKlasse) parentElement;
			return RahmenwerkService.getService().getBenutzerverwaltung().getBenutzer(klasse).toArray();
		}

		return result.toArray(new Object[result.size()]);
	}

	@Override
	public Object getParent(final Object element) {
		return null;
	}

	@Override
	public boolean hasChildren(final Object element) {
		return getChildren(element).length > 0;
	}

	@Override
	public Object[] getElements(final Object inputElement) {
		return getChildren(inputElement);
	}

	@Override
	public Color getBackground(final Object element) {
		return null;
	}

	@Override
	public Color getForeground(final Object element) {
		return null;
	}

	@Override
	public void inputChanged(final Viewer viewer, final Object oldInput, final Object newInput) {
		// keine Aktion vorgesehen
	}

	@Override
	public void dispose() {
		// keine Ressourcen freizugeben
	}
}
