/*
 * Rahmenwerk-Plug-in "Benutzerverwaltung/Zugriffsrechte"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.buv.plugin.benutzervew.views;

import java.util.Comparator;

import de.bsvrz.buv.plugin.benutzervew.data.Benutzer;
import de.bsvrz.buv.plugin.benutzervew.views.BenutzerListeSorter.Direction;

/**
 * Spalten-Sorter Benutzer-Liste.
 *
 * @author BitCtrl Systems GmbH, Steffen Gieseler
 */
public class BenutzerSpaltenSorter implements IBenutzerSorter {

	/**
	 * Priorit&auml;t.
	 */
	private final int columnPriority;

	/**
	 * Richtung.
	 */
	private final Direction defaultDirection;

	/**
	 * Comparator.
	 */
	private final Comparator<Benutzer> comparator;

	/**
	 * Konstruktor.
	 *
	 * @param comparator Comparator
	 */
	public BenutzerSpaltenSorter(final Comparator<Benutzer> comparator) {
		this.columnPriority = 5;
		this.defaultDirection = Direction.ASCENDING;
		this.comparator = comparator;
	}

	/**
	 * Konstruktor.
	 *
	 * @param columnPriority   Priorit&auml;t
	 * @param defaultDirection Richtung
	 * @param comparator       Comparator
	 */
	public BenutzerSpaltenSorter(final int columnPriority, final Direction defaultDirection,
			final Comparator<Benutzer> comparator) {
		this.columnPriority = columnPriority;
		this.defaultDirection = defaultDirection;
		this.comparator = comparator;
	}

	@Override
	public int compare(final Object o1, final Object o2) {
		return comparator.compare((Benutzer) o1, (Benutzer) o2);
	}

	@Override
	public int getColumnPriority() {
		return columnPriority;
	}

	@Override
	public Direction getDefaultDirection() {
		return defaultDirection;
	}
}
