/*
 * Rahmenwerk-Plug-in "Benutzerverwaltung/Zugriffsrechte"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.buv.plugin.benutzervew.views;

import de.bsvrz.buv.plugin.benutzervew.views.BenutzerListeSorter.Direction;

/**
 * Sorter-Interface.
 *
 * @author BitCtrl Systems GmbH, Steffen Gieseler
 *
 */
public interface IBenutzerSorter {

	/**
	 * Returns the default column sorting.
	 *
	 * @return the default column sorting
	 */
	Direction getDefaultDirection();

	/**
	 * Returns the column priority. Based on the column priority an initial sort
	 * order will be determined.
	 *
	 * @return value between 1 and 10
	 */
	int getColumnPriority();

	/**
	 * Compares two objects from the table.
	 *
	 * @param o1 the first object to compare
	 * @param o2 the second object to compare
	 *
	 * @return 0 for o1 = o2, negative value for o1 < o2, positive value for o1 > o2
	 */
	int compare(Object o1, Object o2);

}
