/*
 * Rahmenwerk-Plug-in "Benutzerverwaltung/Zugriffsrechte"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.benutzervew.views;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.part.ViewPart;

import de.bsvrz.buv.plugin.benutzervew.data.Region;
import de.bsvrz.buv.plugin.benutzervew.internal.RahmenwerkService;
import de.bsvrz.buv.rw.basislib.dav.DavVerbindungsEvent;
import de.bsvrz.buv.rw.basislib.dav.DavVerbindungsListener;
import de.bsvrz.sys.funclib.bitctrl.modell.SystemObjekt;
import de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte.ZugriffsRegionNeu;

/**
 * Tabellarische Ansicht über alle Regionen.
 *
 * @author BitCtrl Systems GmbH, ChHoesel
 *
 */
public class RegionenView extends ViewPart {

	private final class VerbindungsListener implements DavVerbindungsListener {
		@Override
		public void verbindungHergestellt(DavVerbindungsEvent event) {
			final RahmenwerkService service = RahmenwerkService.getService();
			final Collection<Region> regionen = RahmenwerkService.getService().getBenutzerverwaltung().getRegionen();
			final List<SystemObjekt> collect = regionen.stream()
					.map(r -> service.getObjektFactory().getModellobjekt(r.getSystemObject()))
					.collect(Collectors.toList());
			viewer.setInput(collect);
		}

		@Override
		public boolean verbindungHalten(DavVerbindungsEvent event) {
			return false;
		}

		@Override
		public void verbindungGetrennt(DavVerbindungsEvent event) {
			viewer.setInput(new Object[0]);
		}
	}

	public static final String ID = "de.bsvrz.buv.plugin.benutzervew.view.regionen";

	private TableViewer viewer;

	private final VerbindungsListener verbindungsListener = new VerbindungsListener();

	@Override
	public void createPartControl(Composite parent) {

		final Composite tableComposite = new Composite(parent, SWT.NONE);
		final TableColumnLayout tableColumnLayout = new TableColumnLayout();
		tableComposite.setLayout(tableColumnLayout);

		viewer = new TableViewer(tableComposite, SWT.SINGLE | SWT.H_SCROLL | SWT.V_SCROLL | SWT.FULL_SELECTION);
		final Table table = viewer.getTable();
		table.setHeaderVisible(true);
		table.setLinesVisible(true);
		viewer.setContentProvider(ArrayContentProvider.getInstance());
		viewer.setLabelProvider(new LabelProvider());

		final TableViewerColumn colName = new TableViewerColumn(viewer, SWT.NONE);
		tableColumnLayout.setColumnData(colName.getColumn(), new ColumnWeightData(150, 200, true));
		colName.getColumn().setText("Name");
		colName.setLabelProvider(new ColumnLabelProvider() {
			@Override
			public String getText(Object element) {
				if (element instanceof ZugriffsRegionNeu) {
					return ((ZugriffsRegionNeu) element).getName();
				}
				return super.getText(element);
			}
		});

		final TableViewerColumn colPid = new TableViewerColumn(viewer, SWT.NONE);
		tableColumnLayout.setColumnData(colPid.getColumn(), new ColumnWeightData(150, 200, true));
		colPid.getColumn().setText("Pid");
		colPid.setLabelProvider(new ColumnLabelProvider() {
			@Override
			public String getText(Object element) {
				if (element instanceof ZugriffsRegionNeu) {
					return ((ZugriffsRegionNeu) element).getPid();
				}
				return super.getText(element);
			}
		});

		final RahmenwerkService service = RahmenwerkService.getService();
		service.getRahmenWerk().addDavVerbindungsListener(verbindungsListener);
		getSite().setSelectionProvider(viewer);

		final Collection<Region> regionen = RahmenwerkService.getService().getBenutzerverwaltung().getRegionen();
		final List<SystemObjekt> collect = regionen.stream()
				.map(r -> service.getObjektFactory().getModellobjekt(r.getSystemObject())).collect(Collectors.toList());
		viewer.setInput(collect);

		final MenuManager menuManager = new MenuManager("#PopupMenu");
		final Menu menu = menuManager.createContextMenu(parent);

		viewer.getControl().setMenu(menu);
		getViewSite().registerContextMenu(menuManager, viewer);
	}

	@Override
	public void dispose() {
		RahmenwerkService.getService().getRahmenWerk().removeDavVerbindungsListener(verbindungsListener);
		super.dispose();
	}

	@Override
	public void setFocus() {
		viewer.getControl().setFocus();

	}

}
