/*
 * Rahmenwerk-Plug-in "Benutzerverwaltung/Zugriffsrechte"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.buv.plugin.benutzervew.wizards;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.PlatformUI;

import de.bsvrz.buv.plugin.benutzervew.PluginBenutzerVew;
import de.bsvrz.buv.plugin.benutzervew.data.Benutzer;
import de.bsvrz.buv.plugin.benutzervew.data.Benutzerverwaltung;
import de.bsvrz.buv.plugin.benutzervew.data.BerechtigungsKlasse;
import de.bsvrz.buv.plugin.benutzervew.internal.RahmenwerkService;

/**
 * Die Datenseite eines Wizards zum Bearbeiten eines Benutzers.
 *
 * @author BitCtrl Systems GmbH, Schumann, Gieseler
 */
public class BenutzerBerechtigungsKlassenWizardPage extends WizardPage {

	/** Die Context-Hilfe-ID. */
	private static final String HILFE_ID = PluginBenutzerVew.PLUGIN_ID + "."
			+ BenutzerBerechtigungsKlassenWizardPage.class.getSimpleName();

	/** Auswahlliste Berechtigungsklassen. */
	private CheckboxTableViewer berechtigungsklassen;

	/** Der zu bearbeitende Nutzer. */
	private Benutzer benutzer;

	/** die initiale Benutzerklasse. */
	private BerechtigungsKlasse berechtigungsKlasse;

	/** Nutzer ist editierbar? */
	private final boolean editable = true;

	/**
	 * Konstruktor.
	 *
	 * @param benutzer der Nutzer.
	 */
	public BenutzerBerechtigungsKlassenWizardPage(final Benutzer benutzer) {
		super("Nutzer");

		setTitle("Wählen Sie die Berechtigungsklasse für den Benutzer aus:");

		this.benutzer = benutzer;
	}

	/**
	 * Konstruktor.
	 *
	 * @param benutzer der Nutzer.
	 */
	public BenutzerBerechtigungsKlassenWizardPage(BerechtigungsKlasse benutzerKlasse) {
		super("Nutzer");
		setTitle("Wählen Sie die Berechtigungsklasse für den Benutzer aus:");
		this.berechtigungsKlasse = benutzerKlasse;
	}

	@Override
	public void createControl(final Composite parent) {
		// Online-Hilfe hinzufügen
		PlatformUI.getWorkbench().getHelpSystem().setHelp(parent, BenutzerBerechtigungsKlassenWizardPage.HILFE_ID);

		final Benutzerverwaltung bv = RahmenwerkService.getService().getBenutzerverwaltung();

		final Composite panel = new Composite(parent, SWT.NONE);
		GridLayoutFactory.fillDefaults().applyTo(panel);

		berechtigungsklassen = CheckboxTableViewer.newCheckList(panel, SWT.BORDER | SWT.READ_ONLY);
		berechtigungsklassen.getControl().setEnabled(editable);
		berechtigungsklassen.setContentProvider(new ArrayContentProvider());
		berechtigungsklassen.setComparator(new ViewerComparator());
		berechtigungsklassen.setInput(bv.getBerechtigungsklassen().toArray());
		if (benutzer == null) {
			if (berechtigungsKlasse != null) {
				berechtigungsklassen.setCheckedElements(new BerechtigungsKlasse[] { berechtigungsKlasse });
			}
		} else {
			berechtigungsklassen.setCheckedElements(benutzer.getBerechtigungsKlassen().toArray());
		}
		if (!RahmenwerkService.getService().getRahmenWerk().usesBerechtigungenNeu()) {
			berechtigungsklassen.addCheckStateListener(
					(event) -> berechtigungsklassen.setCheckedElements(new Object[] { event.getElement() }));
		}

		GridDataFactory.fillDefaults().grab(true, true).applyTo(berechtigungsklassen.getControl());

		setControl(panel);
	}

	/**
	 * Flag ob mit der Page ein Benutzer bearbeitet oder neu angelegt wird.
	 *
	 * @return {@code true}, wenn ein vorhandener Benutzer bearbeitet wird und
	 *         {@code false}, wenn ein neuer Benutzer angelegt wird.
	 */
	public boolean isBearbeiten() {
		return benutzer != null;
	}

	/**
	 * Liefert die ausgew&auml;hlte Berechtigungsklasse.
	 *
	 * @return Berechtigungsklasse.
	 */
	public Collection<BerechtigungsKlasse> getBerechtigungsklassen() {
		final Collection<BerechtigungsKlasse> result = new ArrayList<>();
		final Object[] elements = berechtigungsklassen.getCheckedElements();
		for (final Object element : elements) {
			if (element instanceof BerechtigungsKlasse) {
				result.add((BerechtigungsKlasse) element);
			}
		}
		return result;
	}
}
