/*
 * Rahmenwerk-Plug-in "Benutzerverwaltung/Zugriffsrechte"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.buv.plugin.benutzervew.wizards;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

import de.bsvrz.buv.plugin.benutzervew.PluginBenutzerVew;
import de.bsvrz.buv.plugin.benutzervew.data.Benutzer;

/**
 * Die Datenseite eines Wizards zur Eingabe der Einmalpassworte eines Benutzers.
 *
 * @author BitCtrl Systems GmbH, Schumann, Gieseler
 */
public class BenutzerEinmalPassworteWizardPage extends WizardPage {

	/** Die Context-Hilfe-ID. */
	private static final String HILFE_ID = PluginBenutzerVew.PLUGIN_ID + "."
			+ BenutzerEinmalPassworteWizardPage.class.getSimpleName();

	/** Die Liste der Einmalpassworte. */
	private Text passwortListe;

	/**
	 * Konstruktor.
	 *
	 * @param benutzer der Nutzer.
	 */
	public BenutzerEinmalPassworteWizardPage(final Benutzer benutzer) {
		super("Benutzer");

		setTitle("Geben Sie hier die Einmalpassworte für den Nutzer ein:");

		if (benutzer != null) {
			// TODO Einmalpassworte lesen (von DAV nicht unterstützt)
			setMessage("Die aktuellen Einmalpassworte des Benutzers können nicht gelesen werden", WARNING);
		}
	}

	@Override
	public void createControl(final Composite parent) {
		// Online-Hilfe hinzufügen
		PlatformUI.getWorkbench().getHelpSystem().setHelp(parent, BenutzerEinmalPassworteWizardPage.HILFE_ID);

		final Composite panel = new Composite(parent, SWT.NONE);

		panel.setLayout(new GridLayout(1, false));
		panel.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));

		final Group pwGruppe = new Group(panel, SWT.SHADOW_ETCHED_IN);
		pwGruppe.setText("Liste der Einmalpassworte:");
		pwGruppe.setLayout(new GridLayout(1, true));
		pwGruppe.setLayoutData(new GridData(GridData.GRAB_HORIZONTAL | GridData.FILL_HORIZONTAL));

		passwortListe = new Text(pwGruppe, SWT.MULTI);
		final GridData data = new GridData(GridData.FILL_HORIZONTAL);
		data.heightHint = 150;

		passwortListe.setLayoutData(data);

		setControl(panel);
	}

	/**
	 * Gibt die Einmalpassworte zur&uuml;ck.
	 *
	 * @return Liste der Einmalpassworte
	 */
	public List<String> getEinmalPassworte() {
		final List<String> pwlist = new ArrayList<>();

		final String pw = passwortListe.getText();
		final String del = passwortListe.getLineDelimiter();
		final String[] s;

		if (pw.length() > 0) {
			s = pw.split(del);
			if (s.length > 0) {
				for (final String element : s) {
					pwlist.add(element);
				}
			}
		}

		return pwlist;
	}
}
