/*
 * Rahmenwerk-Plug-in "Benutzerverwaltung/Zugriffsrechte"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.buv.plugin.benutzervew.wizards;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

import de.bsvrz.buv.plugin.benutzervew.data.Benutzer;
import de.bsvrz.buv.plugin.benutzervew.data.BenutzerChangeException;
import de.bsvrz.buv.plugin.benutzervew.data.Benutzerverwaltung;
import de.bsvrz.buv.plugin.benutzervew.data.KeineRechteException;
import de.bsvrz.buv.plugin.benutzervew.internal.RahmenwerkService;
import de.bsvrz.sys.funclib.debug.Debug;

/**
 * Ein Wizard zum &Auml;ndern des Passwortes eines Benutzers.
 *
 * @author BitCtrl Systems GmbH, Schumann, Gieseler
 */
public class BenutzerPasswortWizard extends Wizard implements INewWizard {

	/** Die Datenseite mit den entsprechenden Daten. */
	private BenutzerPasswortWizardPage page;

	/** Der Nutzer, der bearbeitet werden soll. */
	private final Benutzer benutzer;

	/** Debug-Logger. */
	private final Debug log = Debug.getLogger();

	/**
	 * Konstruktor.
	 *
	 * @param benutzer der Benutzer, dessen Passwort ge&auml;ndert werden soll.
	 *
	 */
	public BenutzerPasswortWizard(final Benutzer benutzer) {
		Assert.isNotNull(benutzer, "Der Benutzer darf nicht null sein.");

		final Benutzerverwaltung bv = RahmenwerkService.getService().getBenutzerverwaltung();

		if (benutzer == bv.getAngemeldetenBenutzer()) {
			setWindowTitle("Eigenes Passwort ändern");
		} else {
			setWindowTitle("Benutzerpasswort ändern");
		}

		this.benutzer = benutzer;
	}

	@Override
	public void addPages() {
		page = new BenutzerPasswortWizardPage(benutzer);
		addPage(page);
	}

	/**
	 * &Auml;ndert das Passwortes eines Benutzers.
	 *
	 * @return Passwortes ge&auml;ndert?.
	 */
	private boolean changeUserPasswort() {
		String ordererName;
		String ordererPasswort;
		final Benutzerverwaltung bv = RahmenwerkService.getService().getBenutzerverwaltung();

		if (benutzer == bv.getAngemeldetenBenutzer()) {
			ordererName = RahmenwerkService.getService().getRahmenWerk().getBenutzerName();
			ordererPasswort = page.getPasswortAktuell();
		} else {
			ordererName = RahmenwerkService.getService().getRahmenWerk().getBenutzerName();
			ordererPasswort = RahmenwerkService.getService().getRahmenWerk().getPasswort();
		}

		try {
			bv.aendernPasswort(ordererName, ordererPasswort, benutzer, page.getPasswort());
		} catch (final KeineRechteException ex) {
			String s = ex.getLocalizedMessage();
			if (ex.getCause() != null) {
				s += " " + ex.getCause().getLocalizedMessage();
			}
			page.setErrorMessage(s);
			log.error(ex.getLocalizedMessage(), ex);
			return false;
		} catch (final BenutzerChangeException ex) {
			String s = ex.getLocalizedMessage();
			if (ex.getCause() != null) {
				s += " " + ex.getCause().getLocalizedMessage();
			}
			page.setErrorMessage(s);
			log.error(ex.getLocalizedMessage(), ex);
			return false;
		}

		return true;
	}

	@Override
	public void init(final IWorkbench workbench, final IStructuredSelection selection) {
		// nix
	}

	@Override
	public boolean performFinish() {
		return changeUserPasswort();
	}
}
