/*
 * Rahmenwerk-Plug-in "Benutzerverwaltung/Zugriffsrechte"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.buv.plugin.benutzervew.wizards;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.Window;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

import de.bsvrz.buv.plugin.benutzervew.data.BerechtigungsKlasse;
import de.bsvrz.buv.plugin.benutzervew.internal.RahmenwerkService;
import de.bsvrz.buv.rw.basislib.Rahmenwerk;
import de.bsvrz.buv.rw.basislib.urlasser.UrlasserInfoDatenDialog;

/**
 * Ein Wizard zum Bearbeiten der Eigenschaften einer Nutzergruppe.
 *
 * @author BitCtrl Systems GmbH, Schumann
 */
public class BerechtigungsklasseWizard extends Wizard implements INewWizard {

	/** Die Seite in der die Daten dargestellt werden. */
	private BerechtigungsklasseWizardPage page;

	/** Die Gruppe, deren Daten bearbeitet werden sollen. */
	private final BerechtigungsKlasse klasse;

	/**
	 * Konstruktor.
	 *
	 * @param klasse die Berechtigungsklasse
	 */
	public BerechtigungsklasseWizard(final BerechtigungsKlasse klasse) {
		Assert.isNotNull(klasse, "Die Berechtigungsklasse darf nicht null sein.");
		setWindowTitle("Berechtigungsklasse bearbeiten");
		this.klasse = klasse;
	}

	@Override
	public void addPages() {
		page = new BerechtigungsklasseWizardPage(klasse);
		addPage(page);
	}

	@Override
	public void init(final IWorkbench workbench, final IStructuredSelection selection) {
		// nix
	}

	@Override
	public boolean performFinish() {

		final Rahmenwerk rahmenwerk = RahmenwerkService.getService().getRahmenWerk();
		if (!rahmenwerk.isOnline()) {
			return false;
		}

		final UrlasserInfoDatenDialog dialog = new UrlasserInfoDatenDialog(new Shell(Display.getDefault()),
				(verbindung, urlasser) -> klasse.sendeRolleRegionenPaare(page.getRollenRegionenPaare(), urlasser));

		dialog.setInitialBenutzer(rahmenwerk.getBenutzerName());
		dialog.setInitialVeranlasser(rahmenwerk.getBenutzerName());
		dialog.setInitialUrsache("Berechtigungsklasse '" + klasse.getName() + "' geändert");

		return dialog.open() == Window.OK;
	}

}
