/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.benutzervew.data;

import de.bsvrz.buv.plugin.benutzervew.data.BenutzerInfo;
import de.bsvrz.buv.plugin.benutzervew.data.BerechtigungsKlasse;
import de.bsvrz.buv.plugin.benutzervew.data.SystemObjectWrapper;
import de.bsvrz.buv.plugin.benutzervew.internal.RahmenwerkService;
import de.bsvrz.buv.rw.basislib.Rahmenwerk;
import de.bsvrz.dav.daf.main.ClientDavInterface;
import de.bsvrz.dav.daf.main.Data;
import de.bsvrz.dav.daf.main.DataDescription;
import de.bsvrz.dav.daf.main.ReceiveOptions;
import de.bsvrz.dav.daf.main.ReceiverRole;
import de.bsvrz.dav.daf.main.ResultData;
import de.bsvrz.dav.daf.main.config.AttributeGroup;
import de.bsvrz.dav.daf.main.config.DataModel;
import de.bsvrz.dav.daf.main.config.DynamicObject;
import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.puk.param.lib.daten.UrlasserInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

public class Benutzer
extends SystemObjectWrapper {
    private static final String ATG_BENUTZER_EIGENSCHAFTEN = "atg.benutzerEigenschaften";
    private static final String ATG_BENUTZER_PARAMETER = "atg.benutzerParameter";
    private static final String ATG_BERECHTIGUNGSKLASSEN = "atg.berechtigungsklassen";
    private final BenutzerInfo info = new BenutzerInfo();
    private final Set<BerechtigungsKlasse> berechtigungsKlassen = new LinkedHashSet<BerechtigungsKlasse>();
    private final DataDescription berechtigungsDesc;
    private final DataDescription berechtigungsDescVorgabe;

    public Benutzer(SystemObject systemObject) {
        super(systemObject);
        ClientDavInterface dav = RahmenwerkService.getService().getRahmenWerk().getDavVerbindung();
        DataModel dataModel = systemObject.getDataModel();
        this.readBenutzerInfo(((DynamicObject)systemObject).getConfigurationData(dataModel.getAttributeGroup(ATG_BENUTZER_EIGENSCHAFTEN)));
        if (RahmenwerkService.getService().getRahmenWerk().usesBerechtigungenNeu()) {
            this.berechtigungsDesc = new DataDescription(dataModel.getAttributeGroup(ATG_BERECHTIGUNGSKLASSEN), this.getAspectParameterSoll());
            this.berechtigungsDescVorgabe = new DataDescription(dataModel.getAttributeGroup(ATG_BERECHTIGUNGSKLASSEN), this.getAspectParameterVorgabe());
        } else {
            this.berechtigungsDesc = new DataDescription(dataModel.getAttributeGroup(ATG_BENUTZER_PARAMETER), this.getAspectParameterSoll());
            this.berechtigungsDescVorgabe = new DataDescription(dataModel.getAttributeGroup(ATG_BENUTZER_PARAMETER), this.getAspectParameterVorgabe());
        }
        this.updateBerechtigungsKlassen(dav.getData(systemObject, this.berechtigungsDesc, 0L));
        dav.subscribeReceiver(results -> this.updateBerechtigungsKlassen(results), systemObject, this.berechtigungsDesc, ReceiveOptions.normal(), ReceiverRole.receiver());
    }

    private void readBenutzerInfo(Data data) {
        if (data == null) {
            return;
        }
        this.info.setVorname(data.getTextValue("vorname").getText());
        this.info.setZweiterVorname(data.getTextValue("zweiterVorname").getText());
        this.info.setNachname(data.getTextValue("nachname").getText());
        this.info.setOrganisation(data.getTextValue("organisation").getText());
        this.info.setEmailAdresse(data.getTextValue("emailAdresse").getText());
    }

    private void updateBerechtigungsKlassen(ResultData ... results) {
        ResultData[] resultDataArray = results;
        int n = results.length;
        int n2 = 0;
        while (n2 < n) {
            ResultData result = resultDataArray[n2];
            this.berechtigungsKlassen.clear();
            if (result.hasData()) {
                BerechtigungsKlasse berechtigungsklasse;
                if (ATG_BERECHTIGUNGSKLASSEN.equals(result.getDataDescription().getAttributeGroup().getPid())) {
                    Data.Array array = result.getData().getArray("Berechtigungsklassen");
                    int idx = 0;
                    while (idx < array.getLength()) {
                        BerechtigungsKlasse berechtigungsklasse2 = RahmenwerkService.getService().getBenutzerverwaltung().getBerechtigungsklasse(array.getReferenceValue(idx).getSystemObjectPid());
                        if (berechtigungsklasse2 != null) {
                            this.berechtigungsKlassen.add(berechtigungsklasse2);
                        }
                        ++idx;
                    }
                } else if (ATG_BENUTZER_PARAMETER.equals(result.getDataDescription().getAttributeGroup().getPid()) && (berechtigungsklasse = RahmenwerkService.getService().getBenutzerverwaltung().getBerechtigungsklasse(result.getData().getReferenceValue("berechtigungsklasse").getSystemObjectPid())) != null) {
                    this.berechtigungsKlassen.add(berechtigungsklasse);
                }
                RahmenwerkService.getService().getBenutzerverwaltung().fireBenutzerChanged(this);
            }
            ++n2;
        }
    }

    public void sendeBerechtigungsKlassen(Collection<BerechtigungsKlasse> klassen, UrlasserInfo urlasser) {
        Rahmenwerk rahmenWerk = RahmenwerkService.getService().getRahmenWerk();
        if (!rahmenWerk.isOnline()) {
            return;
        }
        ClientDavInterface dav = rahmenWerk.getDavVerbindung();
        AttributeGroup atg = this.berechtigungsDescVorgabe.getAttributeGroup();
        Data data = dav.createData(atg);
        if (ATG_BENUTZER_PARAMETER.equals(atg.getPid())) {
            if (!klassen.isEmpty()) {
                data.getReferenceValue("berechtigungsklasse").setSystemObject(klassen.iterator().next().getSystemObject());
            }
        } else if (ATG_BERECHTIGUNGSKLASSEN.equals(atg.getPid())) {
            Data.Array array = data.getArray("Berechtigungsklassen");
            array.setLength(klassen.size());
            int idx = 0;
            for (BerechtigungsKlasse klasse : klassen) {
                array.getReferenceValue(idx).setSystemObject(klasse.getSystemObject());
                ++idx;
            }
        }
        if (urlasser != null) {
            Data urlasserItem = data.getItem("Urlasser");
            urlasserItem.getReferenceValue("BenutzerReferenz").setSystemObject(urlasser.getBenutzer());
            urlasserItem.getTextValue("Ursache").setText(urlasser.getUrsache());
            urlasserItem.getTextValue("Veranlasser").setText(urlasser.getVeranlasser());
        }
        RahmenwerkService.getService().getBenutzerverwaltung().getSender().sende(new ResultData(this.getSystemObject(), this.berechtigungsDescVorgabe, 0L, data));
    }

    public Set<BerechtigungsKlasse> getBerechtigungsKlassen() {
        return this.berechtigungsKlassen;
    }

    public String getNachname() {
        return this.info.getNachname();
    }

    public String getVorname() {
        return this.info.getVorname();
    }

    public String getZweiterVorname() {
        return this.info.getZweiterVorname();
    }

    public String getOrganisation() {
        return this.info.getOrganisation();
    }

    public String getEmailAdresse() {
        return this.info.getEmailAdresse();
    }

    public String getBerechtigungsKlassenAsString() {
        ArrayList<BerechtigungsKlasse> bkListe = new ArrayList<BerechtigungsKlasse>(this.berechtigungsKlassen);
        Collections.sort(bkListe, (o1, o2) -> o1.getName().compareTo(o2.getName()));
        return Arrays.toString(bkListe.toArray()).substring(1).replace("]", "");
    }
}

