/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.benutzervew.data;

import de.bsvrz.buv.plugin.benutzervew.data.AngemeldeteApplikation;
import de.bsvrz.buv.plugin.benutzervew.data.Benutzer;
import de.bsvrz.buv.plugin.benutzervew.data.BenutzerChangeException;
import de.bsvrz.buv.plugin.benutzervew.data.BenutzerInfo;
import de.bsvrz.buv.plugin.benutzervew.data.BenutzerListener;
import de.bsvrz.buv.plugin.benutzervew.data.BerechtigungsKlasse;
import de.bsvrz.buv.plugin.benutzervew.data.DatenVerteiler;
import de.bsvrz.buv.plugin.benutzervew.data.KeineRechteException;
import de.bsvrz.buv.plugin.benutzervew.data.PasswortInfo;
import de.bsvrz.buv.plugin.benutzervew.data.Region;
import de.bsvrz.buv.plugin.benutzervew.data.Rolle;
import de.bsvrz.buv.plugin.benutzervew.data.RolleRegionPaar;
import de.bsvrz.buv.plugin.benutzervew.data.Sender;
import de.bsvrz.buv.plugin.benutzervew.internal.RahmenwerkService;
import de.bsvrz.dav.daf.main.ClientDavInterface;
import de.bsvrz.dav.daf.main.Data;
import de.bsvrz.dav.daf.main.DataAndATGUsageInformation;
import de.bsvrz.dav.daf.main.config.Aspect;
import de.bsvrz.dav.daf.main.config.AttributeGroup;
import de.bsvrz.dav.daf.main.config.ConfigurationArea;
import de.bsvrz.dav.daf.main.config.ConfigurationChangeException;
import de.bsvrz.dav.daf.main.config.ConfigurationTaskException;
import de.bsvrz.dav.daf.main.config.DataModel;
import de.bsvrz.dav.daf.main.config.DynamicObject;
import de.bsvrz.dav.daf.main.config.DynamicObjectType;
import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.dav.daf.main.config.SystemObjectType;
import de.bsvrz.dav.daf.main.config.management.UserAdministration;
import de.bsvrz.puk.param.lib.daten.UrlasserInfo;
import de.bsvrz.sys.funclib.bitctrl.daf.DavTools;
import de.bsvrz.sys.funclib.debug.Debug;
import de.bsvrz.sys.funclib.dynobj.DynObjektException;
import de.bsvrz.sys.funclib.dynobj.DynamischeObjekte;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.CopyOnWriteArrayList;

public final class Benutzerverwaltung {
    public static final String PRAEFIX_PID = "benutzer.";
    public static final String PID_KLASSE_KEIN_ZUGRIFF = "berechtigungsklasse.keinZugriff";
    public static final String PID_KLASSE_ADMINISTRATOR = "berechtigungsklasse.administrator";
    private static final String BENUTZER_TYP_PID = "typ.benutzer";
    private static final Debug LOGGER = Debug.getLogger();
    private ClientDavInterface dav;
    private final Collection<BenutzerListener> listeners = new CopyOnWriteArrayList<BenutzerListener>();
    private final Map<String, Benutzer> benutzerMap = new LinkedHashMap<String, Benutzer>();
    private final Map<String, BerechtigungsKlasse> berechtigungsKlassenMap = new LinkedHashMap<String, BerechtigungsKlasse>();
    private DatenVerteiler datenVerteiler;
    private final Map<String, Region> regionenMap = new LinkedHashMap<String, Region>();
    private final Map<String, Rolle> rollenMap = new LinkedHashMap<String, Rolle>();
    private final Sender sender = new Sender();

    public void connect(ClientDavInterface connection) {
        SystemObjectType rolleObjectTyp;
        SystemObjectType regionObjectTyp;
        SystemObjectType berechtigungsKlassenObjectTyp;
        if (connection == null) {
            this.disconnect();
            return;
        }
        this.dav = connection;
        this.sender.setDav(connection);
        this.datenVerteiler = new DatenVerteiler((SystemObject)connection.getLocalDav());
        if (RahmenwerkService.getService().getRahmenWerk().usesBerechtigungenNeu()) {
            berechtigungsKlassenObjectTyp = connection.getDataModel().getType("typ.berechtigungsklasseNeu");
            regionObjectTyp = connection.getDataModel().getType("typ.zugriffsRegionNeu");
            rolleObjectTyp = connection.getDataModel().getType("typ.zugriffsRolleNeu");
        } else {
            berechtigungsKlassenObjectTyp = connection.getDataModel().getType("typ.berechtigungsklasse");
            regionObjectTyp = connection.getDataModel().getType("typ.zugriffsRegion");
            rolleObjectTyp = connection.getDataModel().getType("typ.zugriffsRolle");
        }
        regionObjectTyp.getElements().stream().forEach(o -> {
            Region region = this.regionenMap.put(o.getPid(), new Region((SystemObject)o));
        });
        rolleObjectTyp.getElements().stream().forEach(o -> {
            Rolle rolle = this.rollenMap.put(o.getPid(), new Rolle((SystemObject)o));
        });
        berechtigungsKlassenObjectTyp.getElements().stream().forEach(o -> {
            BerechtigungsKlasse berechtigungsKlasse = this.berechtigungsKlassenMap.put(o.getPid(), new BerechtigungsKlasse((SystemObject)o));
        });
        DynamicObjectType benutzerObjectTyp = (DynamicObjectType)connection.getDataModel().getType(BENUTZER_TYP_PID);
        benutzerObjectTyp.getElements().stream().forEach(o -> this.benutzerAngelegt((DynamicObject)o));
        benutzerObjectTyp.addObjectCreationListener(o -> this.benutzerAngelegt(o));
        benutzerObjectTyp.addInvalidationListener(o -> this.benutzerEntfernt(o));
        LOGGER.info("Schnittstelle zur Nutzerverwaltung initialisiert.");
    }

    public void disconnect() {
        this.sender.setDav(null);
        this.benutzerMap.clear();
    }

    private void benutzerAngelegt(DynamicObject neuesBenutzerObjekt) {
        Benutzer benutzer = new Benutzer((SystemObject)neuesBenutzerObjekt);
        this.benutzerMap.put(neuesBenutzerObjekt.getPid(), benutzer);
        this.fireBenutzerAdded(benutzer);
    }

    private void benutzerEntfernt(DynamicObject zuentfernendesBenutzerObjekt) {
        Benutzer benutzer = this.benutzerMap.remove(zuentfernendesBenutzerObjekt.getPid());
        if (benutzer != null) {
            this.fireBenutzerRemoved(benutzer);
        }
    }

    public void addBenutzerListener(BenutzerListener l) {
        this.listeners.add(l);
    }

    public void removeBenutzerListener(BenutzerListener l) {
        this.listeners.remove(l);
    }

    private void fireBenutzerAdded(Benutzer benutzer) {
        for (BenutzerListener l : this.listeners) {
            l.benutzerAdded(benutzer);
        }
    }

    protected synchronized void fireBenutzerRemoved(Benutzer benutzer) {
        for (BenutzerListener l : this.listeners) {
            l.benutzerRemoved(benutzer);
        }
    }

    protected synchronized void fireBenutzerChanged(Benutzer benutzer) {
        for (BenutzerListener l : this.listeners) {
            l.benutzerChanged(benutzer);
        }
    }

    public List<AngemeldeteApplikation> getAnmeldungen(Benutzer benutzer) {
        return this.datenVerteiler.getAngemeldeteApplikationenFor(benutzer);
    }

    public boolean isAngemeldet(Benutzer benutzer) {
        return !this.datenVerteiler.getAngemeldeteApplikationenFor(benutzer).isEmpty();
    }

    public Benutzer getAngemeldetenBenutzer() {
        return this.benutzerMap.get(RahmenwerkService.getService().getRahmenWerk().getBenutzer().getPid());
    }

    public Collection<Benutzer> getBenutzer() {
        return Collections.unmodifiableCollection(this.benutzerMap.values());
    }

    public List<Benutzer> getBenutzer(BerechtigungsKlasse klasse) {
        ArrayList<Benutzer> benutzerListe = new ArrayList<Benutzer>();
        for (Benutzer benutzer : this.benutzerMap.values()) {
            if (!this.isBerechtigungsklasse(benutzer, klasse)) continue;
            benutzerListe.add(benutzer);
        }
        return benutzerListe;
    }

    public Collection<BerechtigungsKlasse> getBerechtigungsklassen() {
        return this.berechtigungsKlassenMap.values();
    }

    public boolean isDAVAdmin(String loginname, String passwort) {
        DataModel modell = this.dav.getDataModel();
        UserAdministration userAdmin = modell.getUserAdministration();
        try {
            return userAdmin.isUserAdmin(loginname, passwort, loginname);
        }
        catch (ConfigurationTaskException e) {
            LOGGER.warning(e.getLocalizedMessage());
            return false;
        }
    }

    private boolean isBerechtigungsklasse(Benutzer benutzer, BerechtigungsKlasse klasse) {
        return benutzer.getBerechtigungsKlassen().contains(klasse);
    }

    public BerechtigungsKlasse getBerechtigungsklasse(Benutzer benutzer) {
        Set<BerechtigungsKlasse> klassen = benutzer.getBerechtigungsKlassen();
        if (klassen.isEmpty()) {
            return null;
        }
        return klassen.iterator().next();
    }

    public boolean isRolleUndRegion(Benutzer benutzer, Rolle rolle, Region region) {
        if (benutzer == null) {
            throw new IllegalArgumentException("Benutzer darf nicht null sein.");
        }
        if (rolle == null) {
            throw new IllegalArgumentException("Zugriffsrolle darf nicht null sein.");
        }
        Set<BerechtigungsKlasse> klassen = benutzer.getBerechtigungsKlassen();
        if (klassen.isEmpty()) {
            LOGGER.info("Dem Benutzer " + benutzer + " ist keine Berechtigungsklasse zugeordnet.");
            return false;
        }
        for (BerechtigungsKlasse klasse : klassen) {
            for (RolleRegionPaar paar : klasse.getRolleRegionenPaare()) {
                if (!(region != null ? region.equals(paar.getRegion()) && rolle.equals(paar.getRolle()) : rolle.equals(paar.getRolle()))) continue;
                return true;
            }
        }
        return false;
    }

    public BerechtigungsKlasse getBerechtigungsklasse(String pid) {
        return this.berechtigungsKlassenMap.get(pid);
    }

    public Collection<Rolle> getRollen() {
        return Collections.unmodifiableCollection(this.rollenMap.values());
    }

    public Benutzer getBenutzer(String loginname) {
        if (loginname == null || loginname.length() == 0) {
            throw new IllegalArgumentException("Der Benutzername darf weder null noch ein Leerstring sein.");
        }
        for (Benutzer benutzer : this.benutzerMap.values()) {
            if (!benutzer.getName().equals(loginname)) continue;
            return benutzer;
        }
        return null;
    }

    public Benutzer getBenutzerWithPid(String benutzerPid) {
        return this.benutzerMap.get(benutzerPid);
    }

    public List<Benutzer> sucheBenutzer(String nachname, String vorname, String zweiterVorname, String organisation, String email) {
        ArrayList<Benutzer> benutzerListe = new ArrayList<Benutzer>();
        for (Benutzer benutzer : this.getBenutzer()) {
            boolean ok = false;
            if (nachname == null || nachname.equals(benutzer.getNachname())) {
                ok = true;
            } else if (vorname == null || vorname.equals(benutzer.getVorname())) {
                ok = true;
            } else if (zweiterVorname == null || zweiterVorname.equals(benutzer.getZweiterVorname())) {
                ok = true;
            } else if (organisation == null || organisation.equals(benutzer.getOrganisation())) {
                ok = true;
            } else if (email == null || email.equals(benutzer.getEmailAdresse())) {
                ok = true;
            }
            if (!ok) continue;
            benutzerListe.add(benutzer);
        }
        return benutzerListe;
    }

    public Benutzer anlegenBenutzer(String adminLoginname, String adminPasswort, String loginName, BenutzerInfo benutzerInfo, boolean adminRechte) throws KeineRechteException, BenutzerChangeException {
        if (!this.isDAVAdmin(adminLoginname, adminPasswort)) {
            throw new KeineRechteException("Sie verf\u00fcgen nicht \u00fcber ausreichend Rechte zum Anlegen eines neuen Benutzer.");
        }
        Benutzer benutzer = null;
        String pid = DavTools.generierePID((String)loginName, (String)PRAEFIX_PID);
        try {
            benutzer = this.benutzerObjektAnlegen(pid, loginName, benutzerInfo);
            DataModel modell = this.dav.getDataModel();
            UserAdministration userAdmin = modell.getUserAdministration();
            DynamicObjectType type = (DynamicObjectType)this.dav.getDataModel().getType(BENUTZER_TYP_PID);
            ConfigurationArea konfigurationsBereich = DynamischeObjekte.getInstanz((ClientDavInterface)this.dav).getKonfigurationsBereich(type);
            userAdmin.createNewUser(adminLoginname, adminPasswort, loginName, pid, benutzerInfo.getPasswort(), adminRechte, konfigurationsBereich.getPid());
        }
        catch (ConfigurationTaskException ex) {
            throw new BenutzerChangeException("Der Benutzer '" + loginName + "' konnte nicht angelegt werden.", ex);
        }
        catch (DynObjektException ex) {
            throw new BenutzerChangeException("Der Benutzer '" + loginName + "' konnte nicht angelegt werden.", ex);
        }
        return benutzer;
    }

    private Benutzer benutzerObjektAnlegen(String pid, String name, BenutzerInfo info) throws DynObjektException {
        AttributeGroup benutzerEigenschaftenAtg = this.dav.getDataModel().getAttributeGroup("atg.benutzerEigenschaften");
        Aspect eigenschaftenAsp = this.dav.getDataModel().getAspect("asp.eigenschaften");
        Data datenSatz = this.dav.createData(benutzerEigenschaftenAtg);
        datenSatz.getTextValue("vorname").setText(info.getVorname());
        datenSatz.getTextValue("zweiterVorname").setText(info.getZweiterVorname());
        datenSatz.getTextValue("nachname").setText(info.getNachname());
        datenSatz.getTextValue("organisation").setText(info.getOrganisation());
        datenSatz.getTextValue("emailAdresse").setText(info.getEmailAdresse());
        DataAndATGUsageInformation configData = new DataAndATGUsageInformation(benutzerEigenschaftenAtg.getAttributeGroupUsage(eigenschaftenAsp), datenSatz);
        SystemObjectType type = this.dav.getDataModel().getType(BENUTZER_TYP_PID);
        return new Benutzer((SystemObject)DynamischeObjekte.getInstanz((ClientDavInterface)this.dav).erzeugeObjekt((DynamicObjectType)type, name, pid, Collections.singleton(configData)));
    }

    public void entfernenBenutzer(String adminLoginname, String adminPasswort, Benutzer benutzer) throws KeineRechteException, BenutzerChangeException {
        if (!this.isDAVAdmin(adminLoginname, adminPasswort)) {
            throw new KeineRechteException("Sie verf\u00fcgen nicht \u00fcber ausreichend Rechte zum L\u00f6schen eines Benutzer.");
        }
        try {
            benutzer.getSystemObject().invalidate();
            UserAdministration userAdministration = this.dav.getDataModel().getUserAdministration();
            userAdministration.deleteUser(adminLoginname, adminPasswort, benutzer.getName());
        }
        catch (ConfigurationChangeException ex) {
            throw new BenutzerChangeException("Das Benutzerobjekt " + benutzer.getName() + " konnte nicht gel\u00f6scht werden.", ex);
        }
        catch (ConfigurationTaskException ex) {
            throw new BenutzerChangeException("Die Benutzerdaten " + benutzer.getName() + " konnten nicht gel\u00f6scht werden.", ex);
        }
    }

    public void setBerechtigungsklassen(String adminLoginname, String adminPasswort, Benutzer benutzer, Collection<BerechtigungsKlasse> klassen, UrlasserInfo urlasserInfo) throws KeineRechteException, BenutzerChangeException {
        if (!this.isDAVAdmin(adminLoginname, adminPasswort)) {
            throw new KeineRechteException("Sie verf\u00fcgen nicht \u00fcber ausreichend Rechte zum \u00c4ndern der Berechtigungsklasse eines Benutzers.");
        }
        benutzer.sendeBerechtigungsKlassen(klassen, urlasserInfo);
    }

    public SortedMap<Integer, String> setEinmalPassworte(String adminLoginname, String adminPasswort, String loginName, List<String> passworte) throws KeineRechteException, BenutzerChangeException {
        if (!this.isDAVAdmin(adminLoginname, adminPasswort)) {
            throw new KeineRechteException("Sie verf\u00fcgen nicht \u00fcber ausreichend Rechte zum \u00c4ndern der Berechtigungsklasse eines Benutzers.");
        }
        try {
            DataModel modell = this.dav.getDataModel();
            UserAdministration userAdmin = modell.getUserAdministration();
            String[] passwortArray = passworte.toArray(new String[passworte.size()]);
            int firstId = userAdmin.createOneTimePasswords(adminLoginname, adminPasswort, loginName, passwortArray);
            TreeMap<Integer, String> result = new TreeMap<Integer, String>();
            int idx = 0;
            while (idx < passwortArray.length) {
                result.put(firstId + idx, passwortArray[idx]);
                ++idx;
            }
            return result;
        }
        catch (ConfigurationChangeException ex) {
            throw new BenutzerChangeException("Die Einmalpassworte f\u00fcr " + loginName + " konnten nicht angelegt werden.", ex);
        }
        catch (ConfigurationTaskException ex) {
            throw new BenutzerChangeException("Die Einmalpassworte f\u00fcr " + loginName + " konnten nicht angelegt werden.", ex);
        }
    }

    public String checkPasswort(String passwort, Benutzer benutzer, PasswortInfo passwortInfo) {
        if (passwort == null) {
            throw new IllegalArgumentException("Passwort darf nicht null sein.");
        }
        long minLaenge = passwortInfo.getMinLaenge();
        if (minLaenge > 0L && (long)passwort.length() < minLaenge) {
            return "Das Passwort muss mindestens " + minLaenge + " Zeichen lang sein.";
        }
        String lowerPasswort = passwort.toLowerCase(Locale.getDefault());
        if (passwortInfo.isGemischteZeichen()) {
            int laenge = lowerPasswort.length();
            int anzahl = 0;
            int i = 0;
            while (i < laenge) {
                if (lowerPasswort.substring(i, i + 1).matches("[a-z]")) {
                    ++anzahl;
                }
                ++i;
            }
            if (anzahl == 0 || anzahl == laenge) {
                return "Das Passwort muss au\u00dfer Buchstaben auch Zahlen oder Sonderzeichen enthalten.";
            }
        }
        if (benutzer != null && passwortInfo.isVergleicheBenutzerdaten()) {
            String loginname = benutzer.getName().toLowerCase(Locale.getDefault());
            String nachname = benutzer.getNachname().toLowerCase(Locale.getDefault());
            String vorname = benutzer.getVorname().toLowerCase(Locale.getDefault());
            if (loginname.contains(lowerPasswort.subSequence(0, lowerPasswort.length() - 1))) {
                return "Das Passwort darf nicht im Loginnamen enthalten sein.";
            }
            if (lowerPasswort.contains(loginname.subSequence(0, loginname.length() - 1))) {
                return "Das Passwort darf nicht den Loginnamen enthalten.";
            }
            if (nachname.contains(lowerPasswort.subSequence(0, lowerPasswort.length() - 1))) {
                return "Das Passwort darf nicht im Nachnamen enthalten sein.";
            }
            if (lowerPasswort.contains(nachname.subSequence(0, nachname.length() - 1))) {
                return "Das Passwort darf nicht den Nachnamen enthalten.";
            }
            if (lowerPasswort.contains(vorname.subSequence(0, vorname.length() - 1))) {
                return "Das Passwort darf nicht im Vornamen enthalten sein.";
            }
            if (vorname.contains(lowerPasswort.subSequence(0, lowerPasswort.length() - 1))) {
                return "Das Passwort darf nicht den Vornamen enthalten.";
            }
        }
        return null;
    }

    public Benutzer aendernPasswort(String adminLoginname, String adminPasswort, Benutzer benutzer, String neuesPasswort) throws KeineRechteException, BenutzerChangeException {
        if (!benutzer.equals(this.getAngemeldetenBenutzer()) && !this.isDAVAdmin(adminLoginname, adminPasswort)) {
            throw new KeineRechteException("Sie verf\u00fcgen nicht \u00fcber ausreichend Rechte zum \u00c4ndern des Passwortes eines Benutzer.");
        }
        try {
            DataModel modell = this.dav.getDataModel();
            UserAdministration userAdmin = modell.getUserAdministration();
            userAdmin.changeUserPassword(adminLoginname, adminPasswort, benutzer.getName(), neuesPasswort);
        }
        catch (ConfigurationTaskException ex) {
            throw new BenutzerChangeException("Das Passwort des Benutzers " + benutzer.getName() + " konnte nicht ge\u00e4ndert werden.", ex);
        }
        return benutzer;
    }

    public Collection<BerechtigungsKlasse> getBerechtigungsKlassen() {
        return Collections.unmodifiableCollection(this.berechtigungsKlassenMap.values());
    }

    public Collection<Region> getRegionen() {
        return Collections.unmodifiableCollection(this.regionenMap.values());
    }

    public Rolle getRolle(String pid) {
        return this.rollenMap.get(pid);
    }

    public Region getRegion(String pid) {
        return this.regionenMap.get(pid);
    }

    public Sender getSender() {
        return this.sender;
    }
}

