/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.benutzervew.data;

import de.bsvrz.buv.plugin.benutzervew.data.Region;
import de.bsvrz.buv.plugin.benutzervew.data.Rolle;
import de.bsvrz.buv.plugin.benutzervew.data.RolleRegionPaar;
import de.bsvrz.buv.plugin.benutzervew.data.SystemObjectWrapper;
import de.bsvrz.buv.plugin.benutzervew.internal.RahmenwerkService;
import de.bsvrz.buv.rw.basislib.Rahmenwerk;
import de.bsvrz.dav.daf.main.ClientDavInterface;
import de.bsvrz.dav.daf.main.Data;
import de.bsvrz.dav.daf.main.DataDescription;
import de.bsvrz.dav.daf.main.ReceiveOptions;
import de.bsvrz.dav.daf.main.ReceiverRole;
import de.bsvrz.dav.daf.main.ResultData;
import de.bsvrz.dav.daf.main.config.AttributeGroup;
import de.bsvrz.dav.daf.main.config.DataModel;
import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.puk.param.lib.daten.UrlasserInfo;
import java.util.ArrayList;
import java.util.Collection;

public class BerechtigungsKlasse
extends SystemObjectWrapper {
    private static final String ATG_ROLLEN_REGIONEN_PARAMETER = "atg.rollenRegionenPaareParameter";
    private static final String ATG_ROLLEN_REGIONEN = "atg.rollenRegionenPaare";
    private final DataDescription rollenRegionenDesc;
    private final DataDescription rollenRegionenDescVorgabe;
    private final Collection<RolleRegionPaar> rolleRegionPaare = new ArrayList<RolleRegionPaar>();

    public BerechtigungsKlasse(SystemObject systemObject) {
        super(systemObject);
        ClientDavInterface dav = RahmenwerkService.getService().getRahmenWerk().getDavVerbindung();
        DataModel dataModel = systemObject.getDataModel();
        if (RahmenwerkService.getService().getRahmenWerk().usesBerechtigungenNeu()) {
            this.rollenRegionenDesc = new DataDescription(dataModel.getAttributeGroup(ATG_ROLLEN_REGIONEN), this.getAspectParameterSoll());
            this.rollenRegionenDescVorgabe = new DataDescription(dataModel.getAttributeGroup(ATG_ROLLEN_REGIONEN), this.getAspectParameterVorgabe());
        } else {
            this.rollenRegionenDesc = new DataDescription(dataModel.getAttributeGroup(ATG_ROLLEN_REGIONEN_PARAMETER), this.getAspectParameterSoll());
            this.rollenRegionenDescVorgabe = new DataDescription(dataModel.getAttributeGroup(ATG_ROLLEN_REGIONEN_PARAMETER), this.getAspectParameterVorgabe());
        }
        this.updateRolleRegionPaare(dav.getData(systemObject, this.rollenRegionenDesc, 0L));
        dav.subscribeReceiver(results -> this.updateRolleRegionPaare(results), systemObject, this.rollenRegionenDesc, ReceiveOptions.normal(), ReceiverRole.receiver());
    }

    private void updateRolleRegionPaare(ResultData ... results) {
        ResultData[] resultDataArray = results;
        int n = results.length;
        int n2 = 0;
        while (n2 < n) {
            ResultData result = resultDataArray[n2];
            this.rolleRegionPaare.clear();
            if (result.hasData()) {
                Region region;
                Rolle rolle;
                int idx;
                Data.Array array;
                if (ATG_ROLLEN_REGIONEN_PARAMETER.equals(result.getDataDescription().getAttributeGroup().getPid())) {
                    array = result.getData().getArray("rollenRegionenPaare");
                    idx = 0;
                    while (idx < array.getLength()) {
                        rolle = RahmenwerkService.getService().getBenutzerverwaltung().getRolle(array.getItem(idx).getReferenceValue("rolle").getSystemObjectPid());
                        region = RahmenwerkService.getService().getBenutzerverwaltung().getRegion(array.getItem(idx).getReferenceValue("region").getSystemObjectPid());
                        if (rolle != null && region != null) {
                            this.rolleRegionPaare.add(new RolleRegionPaar(rolle, region));
                        }
                        ++idx;
                    }
                } else if (ATG_ROLLEN_REGIONEN.equals(result.getDataDescription().getAttributeGroup().getPid())) {
                    array = result.getData().getArray("RollenRegionenPaare");
                    idx = 0;
                    while (idx < array.getLength()) {
                        rolle = RahmenwerkService.getService().getBenutzerverwaltung().getRolle(array.getItem(idx).getReferenceValue("Rolle").getSystemObjectPid());
                        region = RahmenwerkService.getService().getBenutzerverwaltung().getRegion(array.getItem(idx).getReferenceValue("Region").getSystemObjectPid());
                        if (rolle != null && region != null) {
                            this.rolleRegionPaare.add(new RolleRegionPaar(rolle, region));
                        }
                        ++idx;
                    }
                }
            }
            ++n2;
        }
    }

    public Collection<RolleRegionPaar> getRolleRegionenPaare() {
        return new ArrayList<RolleRegionPaar>(this.rolleRegionPaare);
    }

    public void sendeRolleRegionenPaare(Collection<RolleRegionPaar> collection, UrlasserInfo urlasser) {
        Data.Array array;
        Rahmenwerk rahmenWerk = RahmenwerkService.getService().getRahmenWerk();
        if (!rahmenWerk.isOnline()) {
            return;
        }
        ClientDavInterface dav = rahmenWerk.getDavVerbindung();
        AttributeGroup atg = this.rollenRegionenDesc.getAttributeGroup();
        Data data = dav.createData(atg);
        if (ATG_ROLLEN_REGIONEN_PARAMETER.equals(atg.getPid())) {
            array = data.getArray("rollenRegionenPaare");
            array.setLength(collection.size());
            int idx = 0;
            for (RolleRegionPaar paar : collection) {
                array.getItem(idx).getReferenceValue("rolle").setSystemObject(paar.getRolle().getSystemObject());
                array.getItem(idx).getReferenceValue("region").setSystemObject(paar.getRegion().getSystemObject());
                ++idx;
            }
        } else if (ATG_ROLLEN_REGIONEN.equals(atg.getPid())) {
            array = data.getArray("RollenRegionenPaare");
            array.setLength(collection.size());
            int idx = 0;
            for (RolleRegionPaar paar : collection) {
                array.getItem(idx).getReferenceValue("Rolle").setSystemObject(paar.getRolle().getSystemObject());
                array.getItem(idx).getReferenceValue("Region").setSystemObject(paar.getRegion().getSystemObject());
                ++idx;
            }
        }
        if (urlasser != null) {
            Data urlasserItem = data.getItem("Urlasser");
            urlasserItem.getReferenceValue("BenutzerReferenz").setSystemObject(urlasser.getBenutzer());
            urlasserItem.getTextValue("Ursache").setText(urlasser.getUrsache());
            urlasserItem.getTextValue("Veranlasser").setText(urlasser.getVeranlasser());
        }
        RahmenwerkService.getService().getBenutzerverwaltung().getSender().sende(new ResultData(this.getSystemObject(), this.rollenRegionenDescVorgabe, 0L, data));
    }
}

