/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.benutzervew.data;

import de.bsvrz.buv.plugin.benutzervew.data.AngemeldeteApplikation;
import de.bsvrz.buv.plugin.benutzervew.data.Benutzer;
import de.bsvrz.buv.plugin.benutzervew.data.Benutzerverwaltung;
import de.bsvrz.buv.plugin.benutzervew.data.SystemObjectWrapper;
import de.bsvrz.buv.plugin.benutzervew.internal.RahmenwerkService;
import de.bsvrz.dav.daf.main.ClientDavInterface;
import de.bsvrz.dav.daf.main.Data;
import de.bsvrz.dav.daf.main.DataDescription;
import de.bsvrz.dav.daf.main.ReceiveOptions;
import de.bsvrz.dav.daf.main.ReceiverRole;
import de.bsvrz.dav.daf.main.ResultData;
import de.bsvrz.dav.daf.main.config.DataModel;
import de.bsvrz.dav.daf.main.config.SystemObject;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class DatenVerteiler
extends SystemObjectWrapper {
    private static final String ATG_ANGEMELDETE_APPLIKATIONEN = "atg.angemeldeteApplikationen";
    private static final String ASP_STANDARD = "asp.standard";
    private final DataDescription anmeldungenDesc;
    private final Map<SystemObject, AngemeldeteApplikation> angemeldeteApplikationen = new LinkedHashMap<SystemObject, AngemeldeteApplikation>();

    public DatenVerteiler(SystemObject systemObject) {
        super(systemObject);
        ClientDavInterface dav = RahmenwerkService.getService().getRahmenWerk().getDavVerbindung();
        DataModel dataModel = systemObject.getDataModel();
        this.anmeldungenDesc = new DataDescription(dataModel.getAttributeGroup(ATG_ANGEMELDETE_APPLIKATIONEN), dataModel.getAspect(ASP_STANDARD));
        this.updateAngemeldeteApplikationen(dav.getData(systemObject, this.anmeldungenDesc, 0L));
        dav.subscribeReceiver(results -> this.updateAngemeldeteApplikationen(results), systemObject, this.anmeldungenDesc, ReceiveOptions.normal(), ReceiverRole.receiver());
    }

    private void updateAngemeldeteApplikationen(ResultData ... results) {
        LinkedHashSet<SystemObject> vorherigeApplikationen = new LinkedHashSet<SystemObject>(this.angemeldeteApplikationen.keySet());
        LinkedHashSet<String> geaenderteBenutzerPid = new LinkedHashSet<String>();
        ResultData[] resultDataArray = results;
        int n = results.length;
        int n2 = 0;
        while (n2 < n) {
            ResultData result = resultDataArray[n2];
            if (result.hasData()) {
                Data.Array array = result.getData().getArray("angemeldeteApplikation");
                int idx = 0;
                while (idx < array.getLength()) {
                    Data item = array.getItem(idx);
                    SystemObject appObj = item.getReferenceValue("applikation").getSystemObject();
                    if (appObj != null) {
                        AngemeldeteApplikation angemeldeteApplikation = this.angemeldeteApplikationen.get(appObj);
                        if (angemeldeteApplikation == null) {
                            angemeldeteApplikation = new AngemeldeteApplikation(appObj);
                            this.angemeldeteApplikationen.put(appObj, angemeldeteApplikation);
                            geaenderteBenutzerPid.add(item.getReferenceValue("benutzer").getSystemObjectPid());
                        }
                        angemeldeteApplikation.setBenutzerPid(item.getReferenceValue("benutzer").getSystemObjectPid());
                        angemeldeteApplikation.setAnmeldeZeit(item.getTimeValue("seit").getMillis());
                        vorherigeApplikationen.remove(appObj);
                    }
                    ++idx;
                }
                vorherigeApplikationen.stream().forEach(so -> {
                    AngemeldeteApplikation applikation = this.angemeldeteApplikationen.remove(so);
                    if (applikation != null) {
                        geaenderteBenutzerPid.add(applikation.getUserPid());
                    }
                });
            }
            ++n2;
        }
        Benutzerverwaltung benutzerverwaltung = RahmenwerkService.getService().getBenutzerverwaltung();
        for (String benutzerPid : geaenderteBenutzerPid) {
            Benutzer benutzer = benutzerverwaltung.getBenutzerWithPid(benutzerPid);
            if (benutzer == null) continue;
            benutzerverwaltung.fireBenutzerChanged(benutzer);
        }
    }

    public List<AngemeldeteApplikation> getAngemeldeteApplikationenFor(Benutzer benutzer) {
        return this.angemeldeteApplikationen.values().stream().filter(app -> benutzer.getPid().equals(app.getUserPid())).collect(Collectors.toList());
    }
}

