/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.benutzervew.data;

import de.bsvrz.buv.plugin.benutzervew.PluginBenutzerVew;
import de.bsvrz.dav.daf.main.ClientDavInterface;
import de.bsvrz.dav.daf.main.ClientSenderInterface;
import de.bsvrz.dav.daf.main.DataDescription;
import de.bsvrz.dav.daf.main.DataNotSubscribedException;
import de.bsvrz.dav.daf.main.OneSubscriptionPerSendData;
import de.bsvrz.dav.daf.main.ResultData;
import de.bsvrz.dav.daf.main.SendSubscriptionNotConfirmed;
import de.bsvrz.dav.daf.main.SenderRole;
import de.bsvrz.dav.daf.main.config.Aspect;
import de.bsvrz.dav.daf.main.config.AttributeGroup;
import de.bsvrz.dav.daf.main.config.SystemObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class Sender
implements ClientSenderInterface {
    private ClientDavInterface dav;
    private final List<ResultData> requests = new ArrayList<ResultData>();
    private final Set<Anmeldung> anmeldungen = new LinkedHashSet<Anmeldung>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dataRequest(SystemObject object, DataDescription dataDescription, byte state) {
        if (state == 0) {
            this.anmeldungen.add(new Anmeldung(object, dataDescription));
            List<ResultData> list = this.requests;
            synchronized (list) {
                Iterator<ResultData> iterator = this.requests.iterator();
                while (iterator.hasNext()) {
                    ResultData data = iterator.next();
                    if (!Objects.equals(data.getObject(), object) || !Objects.equals(data.getDataDescription().getAttributeGroup(), dataDescription.getAttributeGroup()) || !Objects.equals(data.getDataDescription().getAspect(), dataDescription.getAspect())) continue;
                    if (this.dav != null) {
                        try {
                            this.dav.sendData(data);
                        }
                        catch (DataNotSubscribedException | SendSubscriptionNotConfirmed e) {
                            PluginBenutzerVew.getDefault().getLog().log((IStatus)new Status(4, "de.bsvrz.buv.plugin.benutzervew", "Das Versenden von Benutzerdaten ist fehlgeschlagen.", e));
                        }
                    }
                    iterator.remove();
                }
            }
        }
        this.anmeldungen.remove(new Anmeldung(object, dataDescription));
    }

    public boolean isRequestSupported(SystemObject object, DataDescription dataDescription) {
        return true;
    }

    public void setDav(ClientDavInterface dav) {
        if (Objects.equals(dav, this.dav)) {
            return;
        }
        if (dav == null) {
            this.reset();
        }
        this.dav = dav;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reset() {
        if (this.dav == null) {
            return;
        }
        Collection<Object> collection = this.requests;
        synchronized (collection) {
            this.requests.clear();
        }
        collection = this.anmeldungen;
        synchronized (collection) {
            this.anmeldungen.stream().forEach(anmeldung -> this.dav.unsubscribeSender((ClientSenderInterface)this, ((Anmeldung)anmeldung).systemObject, new DataDescription(((Anmeldung)anmeldung).atg, ((Anmeldung)anmeldung).asp)));
            this.anmeldungen.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sende(ResultData resultData) {
        if (this.dav == null) {
            return;
        }
        if (this.anmeldungen.contains(new Anmeldung(resultData.getObject(), resultData.getDataDescription()))) {
            try {
                this.dav.sendData(resultData);
            }
            catch (DataNotSubscribedException | SendSubscriptionNotConfirmed e) {
                PluginBenutzerVew.getDefault().getLog().log((IStatus)new Status(4, "de.bsvrz.buv.plugin.benutzervew", "Das Versenden von Benutzerdaten ist fehlgeschlagen.", e));
            }
        } else {
            List<ResultData> list = this.requests;
            synchronized (list) {
                this.requests.add(resultData);
                try {
                    this.dav.subscribeSender((ClientSenderInterface)this, resultData.getObject(), resultData.getDataDescription(), SenderRole.sender());
                }
                catch (OneSubscriptionPerSendData e) {
                    PluginBenutzerVew.getDefault().getLog().log((IStatus)new Status(4, "de.bsvrz.buv.plugin.benutzervew", "Die Anmeldung als Sender f\u00fcr Benutzerdaten ist fehlgeschlagen.", (Throwable)e));
                }
            }
        }
    }

    private static class Anmeldung {
        private final SystemObject systemObject;
        private final AttributeGroup atg;
        private final Aspect asp;

        Anmeldung(SystemObject object, DataDescription dataDescription) {
            this.systemObject = object;
            this.atg = dataDescription.getAttributeGroup();
            this.asp = dataDescription.getAspect();
        }

        public int hashCode() {
            return Objects.hash(this.systemObject, this.atg, this.asp);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Anmeldung other = (Anmeldung)obj;
            boolean result = Objects.equals(other.systemObject, this.systemObject);
            result &= Objects.equals(other.atg, this.atg);
            return result &= Objects.equals(other.asp, this.asp);
        }
    }
}

