/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.benutzervew.editor;

import de.bsvrz.buv.plugin.benutzervew.internal.RahmenwerkService;
import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.dav.daf.main.config.SystemObjectType;
import de.bsvrz.sys.funclib.bitctrl.modell.ObjektFactory;
import de.bsvrz.sys.funclib.bitctrl.modell.SystemObjekt;
import java.util.Collection;
import java.util.Collections;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class ObjekteWizardPage
extends WizardPage {
    private final Collection<SystemObject> verwendeteObjekte = new TreeSet<SystemObject>();
    private TreeViewer listVerfuegbareTypen;
    private TreeViewer listVerwendeteAtg;
    private final ObjektFactory objektFactory;

    public ObjekteWizardPage() {
        super(ObjekteWizardPage.class.getName());
        this.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"de.bsvrz.buv.plugin.benutzervew", (String)"icons/objekte_wizard_page.gif"));
        this.setTitle("Auswahl der Objekte");
        this.setDescription("\u00dcber dieses Array k\u00f6nnen beliebige Konfigurationsobjekte angegeben werden.\nBei einem leeren Array sind alle Konfigurationsobjekte ausgew\u00e4hlt.");
        this.objektFactory = RahmenwerkService.getService().getObjektFactory();
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        container.setLayout((Layout)new GridLayout(3, false));
        Group groupVerfuegbareAtg = new Group(container, 0);
        groupVerfuegbareAtg.setText("Verf\u00fcgbare Objekte");
        groupVerfuegbareAtg.setLayout((Layout)new FillLayout());
        groupVerfuegbareAtg.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).span(1, 1).hint(300, 400).create());
        this.listVerfuegbareTypen = new TreeViewer((Composite)groupVerfuegbareAtg, 2818);
        this.listVerfuegbareTypen.setContentProvider((IContentProvider)new SystemObjekteTreeContentProvider());
        this.listVerfuegbareTypen.setFilters(new ViewerFilter[]{new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof SystemObjectType) {
                    return !((SystemObjectType)element).getElements().isEmpty();
                }
                return !ObjekteWizardPage.this.verwendeteObjekte.contains(element);
            }
        }});
        this.listVerfuegbareTypen.setInput((Object)this.objektFactory.getDav().getDataModel().getTypeTypeObject().getElements());
        Composite buttonComposite = new Composite(container, 0);
        buttonComposite.setLayout((Layout)new GridLayout(1, false));
        buttonComposite.setLayoutData((Object)GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, true).hint(100, -1).create());
        Button btnEinfuegen = new Button(buttonComposite, 0);
        btnEinfuegen.setLayoutData((Object)new GridData(4, 1024, true, true, 1, 1));
        btnEinfuegen.setText(">>");
        btnEinfuegen.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)ObjekteWizardPage.this.listVerfuegbareTypen.getSelection();
                ObjekteWizardPage.this.verwendeteObjekte.addAll(selection.toList());
                ObjekteWizardPage.this.listVerfuegbareTypen.refresh();
                ObjekteWizardPage.this.listVerwendeteAtg.refresh();
            }
        });
        Button btnEntfernen = new Button(buttonComposite, 0);
        btnEntfernen.setLayoutData((Object)GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, true).hint(100, -1).create());
        btnEntfernen.setText("<<");
        btnEntfernen.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)ObjekteWizardPage.this.listVerwendeteAtg.getSelection();
                ObjekteWizardPage.this.verwendeteObjekte.removeAll(selection.toList());
                ObjekteWizardPage.this.listVerfuegbareTypen.refresh();
                ObjekteWizardPage.this.listVerwendeteAtg.refresh();
            }
        });
        Group groupVerwendeteKB = new Group(container, 0);
        groupVerwendeteKB.setText("Verwendete Objekte");
        groupVerwendeteKB.setLayout((Layout)new FillLayout());
        groupVerwendeteKB.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).span(1, 1).hint(300, 400).create());
        this.listVerwendeteAtg = new TreeViewer((Composite)groupVerwendeteKB, 2818);
        this.listVerwendeteAtg.setContentProvider((IContentProvider)new SystemObjekteTreeContentProvider());
        this.listVerwendeteAtg.setInput(this.verwendeteObjekte);
    }

    public void setVerwendeteObjekte(Collection<SystemObjekt> feld) {
        this.verwendeteObjekte.addAll(feld.stream().map(o -> o.getSystemObject()).collect(Collectors.toList()));
    }

    public Collection<SystemObjekt> getVerwendeteObjekte() {
        return Collections.unmodifiableCollection(this.verwendeteObjekte.stream().filter(o -> o instanceof SystemObject).map(o -> this.objektFactory.getModellobjekt(o)).collect(Collectors.toList()));
    }

    private static final class SystemObjekteTreeContentProvider
    implements ITreeContentProvider {
        private SystemObjekteTreeContentProvider() {
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }

        public Object getParent(Object element) {
            return null;
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof Collection) {
                return ((Collection)inputElement).toArray();
            }
            return new Object[0];
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof SystemObjectType) {
                return ((SystemObjectType)parentElement).getElements().toArray();
            }
            return new Object[0];
        }
    }
}

