/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.benutzervew.editor.region;

import de.bsvrz.buv.plugin.benutzervew.PluginBenutzerVew;
import de.bsvrz.buv.plugin.benutzervew.editor.NamedFeld;
import de.bsvrz.buv.plugin.benutzervew.editor.region.BereicheWizard;
import de.bsvrz.buv.plugin.benutzervew.editor.region.ObjekteWizard;
import de.bsvrz.buv.plugin.benutzervew.editor.region.RegionEditor;
import de.bsvrz.buv.plugin.benutzervew.editor.region.RegionWizard;
import de.bsvrz.buv.plugin.benutzervew.internal.RahmenwerkService;
import de.bsvrz.buv.rw.basislib.urlasser.UrlasserInfoDatenDialog;
import de.bsvrz.sys.funclib.bitctrl.modell.AnmeldeException;
import de.bsvrz.sys.funclib.bitctrl.modell.DatensendeException;
import de.bsvrz.sys.funclib.bitctrl.modell.ObjektFactory;
import de.bsvrz.sys.funclib.bitctrl.modell.OnlineDatum;
import de.bsvrz.sys.funclib.bitctrl.modell.SystemObjekt;
import de.bsvrz.sys.funclib.bitctrl.modell.att.Attributliste;
import de.bsvrz.sys.funclib.bitctrl.modell.att.Feld;
import de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AtlAusgeschlosseneObjekte;
import de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AtlBereiche;
import de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AtlEnthalteneObjekte;
import de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AtlObjekte;
import de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AtlRegionen;
import de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte.Benutzer;
import de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte.ZugriffsRegionNeu;
import de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.parameter.PdRegion;
import de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser;
import java.util.Collection;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public class RegionPage
extends FormPage {
    private static final String REGION = "Region";
    private static final String TYPEN = "Typen";
    private static final String KONFIGURATIONSBEREICHE = "Konfigurationsbereiche";
    private static final String KONFIGURATIONSVERANTWORTLICHE = "Konfigurationsverantwortliche";
    private static final String OBJEKTE = "Objekte";
    private static final String BEREICHE = "Bereiche";
    private static final String REGIONEN = "Regionen";
    private boolean dirty;
    private TreeViewer enthalteneObjekteViewer;
    private TreeViewer ausgeschlosseneObjekteViewer;
    private PdRegion.Daten regionParameterDaten;

    public RegionPage(FormEditor editor, String id, String title) {
        super(editor, id, title);
    }

    protected void createFormContent(IManagedForm managedForm) {
        managedForm.getForm().setImage(PluginBenutzerVew.getDefault().getImageRegistry().get("icons/region.gif"));
        super.createFormContent(managedForm);
        ZugriffsRegionNeu region = (ZugriffsRegionNeu)this.getEditorInput().getAdapter(ZugriffsRegionNeu.class);
        Assert.isNotNull((Object)region);
        FormToolkit toolkit = managedForm.getToolkit();
        ScrolledForm form = managedForm.getForm();
        form.setText("Regionen parametrieren");
        Composite body = form.getBody();
        toolkit.decorateFormHeading(form.getForm());
        toolkit.paintBordersFor(body);
        form.getBody().setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(true).create());
        this.createEnthalteneObjekteSection(toolkit, form);
        this.createAusgeschlosseneObjekteSection(toolkit, form);
        this.regionParameterDaten = ((PdRegion.Daten)region.getPdRegion().getDatum()).clone();
        this.enthalteneObjekteViewer.setInput((Object)this.regionParameterDaten.getEnthalteneObjekte());
        this.ausgeschlosseneObjekteViewer.setInput((Object)this.regionParameterDaten.getAusgeschlosseneObjekte());
    }

    private void createEnthalteneObjekteSection(FormToolkit toolkit, final ScrolledForm form) {
        Section section = toolkit.createSection(form.getBody(), 456);
        section.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        section.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent event) {
                form.reflow(true);
            }
        });
        section.setText("Enthaltene Objekte");
        section.setDescription("\u00dcber diese Vorgaben werden die in der Region enthaltenen Objekte spezifiziert.");
        Composite sectionClient = toolkit.createComposite((Composite)section);
        sectionClient.setLayout((Layout)new GridLayout(1, false));
        Composite buttonPanel = toolkit.createComposite(sectionClient);
        buttonPanel.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        buttonPanel.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(3).equalWidth(false).create());
        Button anlegenButton = toolkit.createButton(buttonPanel, "Anlegen", 8);
        anlegenButton.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        anlegenButton.addSelectionListener((SelectionListener)new EnthalteneObjekteAnlegenAdapter());
        Button bearbeitenButton = toolkit.createButton(buttonPanel, "Bearbeiten", 8);
        bearbeitenButton.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        bearbeitenButton.setEnabled(false);
        bearbeitenButton.addSelectionListener((SelectionListener)new EnthalteneObjekteBearbeitenAdapter());
        Button entfernenButton = toolkit.createButton(buttonPanel, "Entfernen", 8);
        entfernenButton.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        entfernenButton.setEnabled(false);
        entfernenButton.addSelectionListener((SelectionListener)new EnthalteneObjekteEntfernenAdapter());
        Composite treeComposite = toolkit.createComposite(sectionClient, 0);
        treeComposite.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).minSize(100, 200).create());
        TreeColumnLayout treeLayout = new TreeColumnLayout();
        treeComposite.setLayout((Layout)treeLayout);
        this.enthalteneObjekteViewer = new TreeViewer(treeComposite, 2816);
        this.enthalteneObjekteViewer.setContentProvider((IContentProvider)new ObjekteTreeContentProvider());
        this.enthalteneObjekteViewer.addSelectionChangedListener(event -> {
            Object firstElement = event.getStructuredSelection().getFirstElement();
            boolean datenSelected = firstElement instanceof AtlBereiche | firstElement instanceof AtlRegionen | firstElement instanceof AtlObjekte;
            bearbeitenButton.setEnabled(datenSelected);
            entfernenButton.setEnabled(datenSelected | firstElement instanceof AtlEnthalteneObjekte);
        });
        TreeViewerColumn nameCloumn = new TreeViewerColumn(this.enthalteneObjekteViewer, 0);
        treeLayout.setColumnData((Widget)nameCloumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(50, 100));
        nameCloumn.setLabelProvider((CellLabelProvider)new ObjekteLabelProvider());
        section.setClient((Control)sectionClient);
    }

    private void createAusgeschlosseneObjekteSection(FormToolkit toolkit, final ScrolledForm form) {
        Section section = toolkit.createSection(form.getBody(), 456);
        section.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        section.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent event) {
                form.reflow(true);
            }
        });
        section.setText("Ausgeschlossene Objekte");
        section.setDescription("\u00dcber diese Vorgaben werden die in der Region explizit ausgeschlossenen Objekte spezifiziert.");
        Composite sectionClient = toolkit.createComposite((Composite)section);
        sectionClient.setLayout((Layout)new GridLayout(1, false));
        Composite buttonPanel = toolkit.createComposite(sectionClient);
        buttonPanel.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        buttonPanel.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(3).equalWidth(false).create());
        Button anlegenButton = toolkit.createButton(buttonPanel, "Anlegen", 8);
        anlegenButton.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        anlegenButton.addSelectionListener((SelectionListener)new AusgeschlosseneObjekteAnlegenAdapter());
        Button bearbeitenButton = toolkit.createButton(buttonPanel, "Bearbeiten", 8);
        bearbeitenButton.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        bearbeitenButton.setEnabled(false);
        bearbeitenButton.addSelectionListener((SelectionListener)new AusgeschlosseneObjekteBearbeitenAdapter());
        Button entfernenButton = toolkit.createButton(buttonPanel, "Entfernen", 8);
        entfernenButton.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        entfernenButton.setEnabled(false);
        entfernenButton.addSelectionListener((SelectionListener)new AusgeschlosseneObjekteEntfernenAdapter());
        Composite treeComposite = toolkit.createComposite(sectionClient, 0);
        treeComposite.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).minSize(100, 200).create());
        TreeColumnLayout treeLayout = new TreeColumnLayout();
        treeComposite.setLayout((Layout)treeLayout);
        this.ausgeschlosseneObjekteViewer = new TreeViewer(treeComposite, 2816);
        this.ausgeschlosseneObjekteViewer.setContentProvider((IContentProvider)new ObjekteTreeContentProvider());
        this.ausgeschlosseneObjekteViewer.addSelectionChangedListener(event -> {
            Object firstElement = event.getStructuredSelection().getFirstElement();
            boolean datenSelected = firstElement instanceof AtlBereiche | firstElement instanceof AtlRegionen | firstElement instanceof AtlObjekte;
            bearbeitenButton.setEnabled(datenSelected);
            entfernenButton.setEnabled(datenSelected | firstElement instanceof AtlAusgeschlosseneObjekte);
        });
        TreeViewerColumn nameCloumn = new TreeViewerColumn(this.ausgeschlosseneObjekteViewer, 0);
        treeLayout.setColumnData((Widget)nameCloumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(50, 100));
        nameCloumn.setLabelProvider((CellLabelProvider)new ObjekteLabelProvider());
        section.setClient((Control)sectionClient);
    }

    public RegionEditor getEditor() {
        return (RegionEditor)super.getEditor();
    }

    public boolean isDirty() {
        return this.dirty;
    }

    protected void setDirty(boolean newDirtyFlag) {
        this.dirty = newDirtyFlag;
        this.firePropertyChange(257);
        if (this.getManagedForm() != null) {
            this.getManagedForm().getForm().getDisplay().asyncExec(() -> this.getManagedForm().dirtyStateChanged());
        }
    }

    public void doSave(IProgressMonitor monitor) {
        UrlasserInfoDatenDialog dialog = new UrlasserInfoDatenDialog(this.getSite().getShell(), (verbindung, urlasserInfo) -> {
            ZugriffsRegionNeu regionNeu = (ZugriffsRegionNeu)this.getEditorInput().getAdapter(ZugriffsRegionNeu.class);
            ObjektFactory objektFactory = RahmenwerkService.getService().getObjektFactory();
            try {
                monitor.beginTask("Speichern", 5);
                regionNeu.getPdRegion().anmeldenSender();
                monitor.worked(1);
                AtlUrlasser urlasser = new AtlUrlasser();
                urlasser.setBenutzerReferenz((Benutzer)objektFactory.getModellobjekt(urlasserInfo.getBenutzer()));
                urlasser.setUrsache(urlasserInfo.getUrsache());
                urlasser.setVeranlasser(urlasserInfo.getVeranlasser());
                monitor.worked(1);
                this.regionParameterDaten.setUrlasser(urlasser);
                monitor.worked(1);
                regionNeu.getPdRegion().sendeDatum((OnlineDatum)this.regionParameterDaten);
                monitor.worked(1);
                regionNeu.getPdRegion().abmeldenSender();
                this.setDirty(false);
            }
            catch (AnmeldeException | DatensendeException e) {
                monitor.setCanceled(true);
                throw new IllegalStateException("Das Speichern neuer (enthaltener & ausgeschlossener) Objekte f\u00fcr die Region \"" + regionNeu + "\" ist fehlgeschlagen.", e);
            }
        });
        dialog.open();
        monitor.done();
        super.doSave(monitor);
    }

    private final class AusgeschlosseneObjekteAnlegenAdapter
    extends SelectionAdapter {
        private AusgeschlosseneObjekteAnlegenAdapter() {
        }

        public void widgetSelected(SelectionEvent e) {
            IStructuredSelection selection = (IStructuredSelection)RegionPage.this.ausgeschlosseneObjekteViewer.getSelection();
            Object firstElement = selection.getFirstElement();
            if (firstElement instanceof NamedFeld) {
                NamedFeld feld = (NamedFeld)((Object)firstElement);
                if (RegionPage.BEREICHE.equals(feld.getName())) {
                    BereicheWizard wiz = new BereicheWizard((Attributliste)((AtlAusgeschlosseneObjekte)feld.getParent()));
                    WizardDialog dialog = new WizardDialog(RegionPage.this.ausgeschlosseneObjekteViewer.getControl().getShell(), (IWizard)wiz);
                    if (dialog.open() == 0) {
                        RegionPage.this.setDirty(true);
                    }
                } else if (RegionPage.REGIONEN.equals(feld.getName())) {
                    RegionWizard wiz = new RegionWizard((Attributliste)((AtlAusgeschlosseneObjekte)feld.getParent()));
                    WizardDialog dialog = new WizardDialog(RegionPage.this.ausgeschlosseneObjekteViewer.getControl().getShell(), (IWizard)wiz);
                    if (dialog.open() == 0) {
                        RegionPage.this.setDirty(true);
                    }
                } else if (RegionPage.OBJEKTE.equals(feld.getName())) {
                    ObjekteWizard wiz = new ObjekteWizard((Attributliste)((AtlAusgeschlosseneObjekte)feld.getParent()));
                    WizardDialog dialog = new WizardDialog(RegionPage.this.ausgeschlosseneObjekteViewer.getControl().getShell(), (IWizard)wiz);
                    if (dialog.open() == 0) {
                        RegionPage.this.setDirty(true);
                    }
                }
            } else {
                RegionPage.this.regionParameterDaten.getAusgeschlosseneObjekte().add((Object)new AtlAusgeschlosseneObjekte());
                RegionPage.this.setDirty(true);
            }
            RegionPage.this.ausgeschlosseneObjekteViewer.refresh();
        }
    }

    private final class AusgeschlosseneObjekteBearbeitenAdapter
    extends SelectionAdapter {
        private AusgeschlosseneObjekteBearbeitenAdapter() {
        }

        public void widgetSelected(SelectionEvent e) {
            IStructuredSelection selection = (IStructuredSelection)RegionPage.this.ausgeschlosseneObjekteViewer.getSelection();
            Object firstElement = selection.getFirstElement();
            if (firstElement instanceof NamedFeld) {
                NamedFeld feld = (NamedFeld)((Object)firstElement);
                if (RegionPage.BEREICHE.equals(feld.getName())) {
                    BereicheWizard wiz = new BereicheWizard((Attributliste)((AtlAusgeschlosseneObjekte)feld.getParent()));
                    WizardDialog dialog = new WizardDialog(RegionPage.this.ausgeschlosseneObjekteViewer.getControl().getShell(), (IWizard)wiz);
                    if (dialog.open() == 0) {
                        RegionPage.this.setDirty(true);
                    }
                }
            } else if (firstElement instanceof AtlBereiche) {
                BereicheWizard wiz = new BereicheWizard((AtlBereiche)firstElement);
                WizardDialog dialog = new WizardDialog(RegionPage.this.ausgeschlosseneObjekteViewer.getControl().getShell(), (IWizard)wiz);
                if (dialog.open() == 0) {
                    RegionPage.this.setDirty(true);
                }
            } else if (firstElement instanceof AtlRegionen) {
                RegionWizard wiz = new RegionWizard((AtlRegionen)firstElement);
                WizardDialog dialog = new WizardDialog(RegionPage.this.ausgeschlosseneObjekteViewer.getControl().getShell(), (IWizard)wiz);
                if (dialog.open() == 0) {
                    RegionPage.this.setDirty(true);
                }
            } else if (firstElement instanceof AtlObjekte) {
                ObjekteWizard wiz = new ObjekteWizard((AtlObjekte)firstElement);
                WizardDialog dialog = new WizardDialog(RegionPage.this.ausgeschlosseneObjekteViewer.getControl().getShell(), (IWizard)wiz);
                if (dialog.open() == 0) {
                    RegionPage.this.setDirty(true);
                }
            }
            RegionPage.this.ausgeschlosseneObjekteViewer.refresh();
        }
    }

    private final class AusgeschlosseneObjekteEntfernenAdapter
    extends SelectionAdapter {
        private AusgeschlosseneObjekteEntfernenAdapter() {
        }

        public void widgetSelected(SelectionEvent e) {
            IStructuredSelection selection = (IStructuredSelection)RegionPage.this.ausgeschlosseneObjekteViewer.getSelection();
            Object firstElement = selection.getFirstElement();
            if (firstElement instanceof AtlBereiche) {
                RegionPage.this.regionParameterDaten.getAusgeschlosseneObjekte().stream().forEach(a -> {
                    boolean bl = a.getBereich().remove(firstElement);
                });
            } else if (firstElement instanceof AtlRegionen) {
                RegionPage.this.regionParameterDaten.getAusgeschlosseneObjekte().stream().forEach(a -> {
                    boolean bl = a.getRegion().remove(firstElement);
                });
            } else if (firstElement instanceof AtlObjekte) {
                RegionPage.this.regionParameterDaten.getAusgeschlosseneObjekte().stream().forEach(a -> {
                    boolean bl = a.getObjekte().remove(firstElement);
                });
            } else if (firstElement instanceof AtlAusgeschlosseneObjekte) {
                RegionPage.this.regionParameterDaten.getAusgeschlosseneObjekte().remove(firstElement);
            }
            RegionPage.this.setDirty(true);
            RegionPage.this.ausgeschlosseneObjekteViewer.refresh();
        }
    }

    private final class EnthalteneObjekteAnlegenAdapter
    extends SelectionAdapter {
        private EnthalteneObjekteAnlegenAdapter() {
        }

        public void widgetSelected(SelectionEvent e) {
            IStructuredSelection selection = (IStructuredSelection)RegionPage.this.enthalteneObjekteViewer.getSelection();
            Object firstElement = selection.getFirstElement();
            if (firstElement instanceof NamedFeld) {
                NamedFeld feld = (NamedFeld)((Object)firstElement);
                if (RegionPage.BEREICHE.equals(feld.getName())) {
                    BereicheWizard wiz = new BereicheWizard((Attributliste)((AtlEnthalteneObjekte)feld.getParent()));
                    WizardDialog dialog = new WizardDialog(RegionPage.this.enthalteneObjekteViewer.getControl().getShell(), (IWizard)wiz);
                    if (dialog.open() == 0) {
                        RegionPage.this.setDirty(true);
                    }
                } else if (RegionPage.REGIONEN.equals(feld.getName())) {
                    RegionWizard wiz = new RegionWizard((Attributliste)((AtlEnthalteneObjekte)feld.getParent()));
                    WizardDialog dialog = new WizardDialog(RegionPage.this.enthalteneObjekteViewer.getControl().getShell(), (IWizard)wiz);
                    if (dialog.open() == 0) {
                        RegionPage.this.setDirty(true);
                    }
                } else if (RegionPage.OBJEKTE.equals(feld.getName())) {
                    ObjekteWizard wiz = new ObjekteWizard((Attributliste)((AtlEnthalteneObjekte)feld.getParent()));
                    WizardDialog dialog = new WizardDialog(RegionPage.this.enthalteneObjekteViewer.getControl().getShell(), (IWizard)wiz);
                    if (dialog.open() == 0) {
                        RegionPage.this.setDirty(true);
                    }
                }
            } else {
                RegionPage.this.regionParameterDaten.getEnthalteneObjekte().add((Object)new AtlEnthalteneObjekte());
                RegionPage.this.setDirty(true);
            }
            RegionPage.this.enthalteneObjekteViewer.refresh();
        }
    }

    private final class EnthalteneObjekteBearbeitenAdapter
    extends SelectionAdapter {
        private EnthalteneObjekteBearbeitenAdapter() {
        }

        public void widgetSelected(SelectionEvent e) {
            IStructuredSelection selection = (IStructuredSelection)RegionPage.this.enthalteneObjekteViewer.getSelection();
            Object firstElement = selection.getFirstElement();
            if (firstElement instanceof NamedFeld) {
                NamedFeld feld = (NamedFeld)((Object)firstElement);
                if (RegionPage.BEREICHE.equals(feld.getName())) {
                    BereicheWizard wiz = new BereicheWizard((Attributliste)((AtlEnthalteneObjekte)feld.getParent()));
                    WizardDialog dialog = new WizardDialog(RegionPage.this.enthalteneObjekteViewer.getControl().getShell(), (IWizard)wiz);
                    if (dialog.open() == 0) {
                        RegionPage.this.setDirty(true);
                    }
                }
            } else if (firstElement instanceof AtlBereiche) {
                BereicheWizard wiz = new BereicheWizard((AtlBereiche)firstElement);
                WizardDialog dialog = new WizardDialog(RegionPage.this.enthalteneObjekteViewer.getControl().getShell(), (IWizard)wiz);
                if (dialog.open() == 0) {
                    RegionPage.this.setDirty(true);
                }
            } else if (firstElement instanceof AtlRegionen) {
                RegionWizard wiz = new RegionWizard((AtlRegionen)firstElement);
                WizardDialog dialog = new WizardDialog(RegionPage.this.enthalteneObjekteViewer.getControl().getShell(), (IWizard)wiz);
                if (dialog.open() == 0) {
                    RegionPage.this.setDirty(true);
                }
            } else if (firstElement instanceof AtlObjekte) {
                ObjekteWizard wiz = new ObjekteWizard((AtlObjekte)firstElement);
                WizardDialog dialog = new WizardDialog(RegionPage.this.enthalteneObjekteViewer.getControl().getShell(), (IWizard)wiz);
                if (dialog.open() == 0) {
                    RegionPage.this.setDirty(true);
                }
            }
            RegionPage.this.enthalteneObjekteViewer.refresh();
        }
    }

    private final class EnthalteneObjekteEntfernenAdapter
    extends SelectionAdapter {
        private EnthalteneObjekteEntfernenAdapter() {
        }

        public void widgetSelected(SelectionEvent e) {
            IStructuredSelection selection = (IStructuredSelection)RegionPage.this.enthalteneObjekteViewer.getSelection();
            Object firstElement = selection.getFirstElement();
            if (firstElement instanceof AtlBereiche) {
                RegionPage.this.regionParameterDaten.getEnthalteneObjekte().stream().forEach(a -> {
                    boolean bl = a.getBereich().remove(firstElement);
                });
            } else if (firstElement instanceof AtlRegionen) {
                RegionPage.this.regionParameterDaten.getEnthalteneObjekte().stream().forEach(a -> {
                    boolean bl = a.getRegion().remove(firstElement);
                });
            } else if (firstElement instanceof AtlObjekte) {
                RegionPage.this.regionParameterDaten.getEnthalteneObjekte().stream().forEach(a -> {
                    boolean bl = a.getObjekte().remove(firstElement);
                });
            } else if (firstElement instanceof AtlEnthalteneObjekte) {
                RegionPage.this.regionParameterDaten.getEnthalteneObjekte().remove(firstElement);
            }
            RegionPage.this.setDirty(true);
            RegionPage.this.enthalteneObjekteViewer.refresh();
        }
    }

    private static final class ObjekteLabelProvider
    extends ColumnLabelProvider {
        private ObjekteLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof AtlEnthalteneObjekte) {
                AtlEnthalteneObjekte objekte = (AtlEnthalteneObjekte)element;
                return "Enthaltene Objekte (" + objekte.getBereich().size() + " Bereiche, " + objekte.getRegion().size() + " Regionen, " + objekte.getObjekte().size() + " Objekte)";
            }
            if (element instanceof AtlAusgeschlosseneObjekte) {
                AtlAusgeschlosseneObjekte objekte = (AtlAusgeschlosseneObjekte)element;
                return "Ausgeschlossene Objekte (" + objekte.getBereich().size() + " Bereiche, " + objekte.getRegion().size() + " Regionen, " + objekte.getObjekte().size() + " Objekte)";
            }
            if (element instanceof AtlBereiche) {
                AtlBereiche bereich = (AtlBereiche)element;
                return "Bereich (" + bereich.getKonfigurationsverantwortlicher().size() + " KV, " + bereich.getKonfigurationsbereich().size() + " KB, " + bereich.getTyp().size() + " Typen, Mengenbez.: " + bereich.getMengenbezeichnung() + ")";
            }
            if (element instanceof AtlRegionen) {
                AtlRegionen region = (AtlRegionen)element;
                return "Region (" + region.getRegion().size() + " Regionen, " + region.getTyp().size() + " Typen, Mengenbez.: " + region.getMengenbezeichnung();
            }
            if (element instanceof AtlObjekte) {
                AtlObjekte objekte = (AtlObjekte)element;
                return "Objekt (" + objekte.getObjekt().size() + "Objekte, Mengenbez.: " + objekte.getMengenbezeichnung() + ")";
            }
            if (element instanceof NamedFeld) {
                NamedFeld feld = (NamedFeld)((Object)element);
                return feld.getName();
            }
            if (element instanceof SystemObjekt) {
                return String.valueOf(((SystemObjekt)element).getName()) + "( " + ((SystemObjekt)element).getPid() + ")";
            }
            return super.getText(element);
        }
    }

    private static final class ObjekteTreeContentProvider
    implements ITreeContentProvider {
        private ObjekteTreeContentProvider() {
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }

        public Object getParent(Object element) {
            return null;
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof Collection) {
                return ((Collection)inputElement).toArray();
            }
            return new Object[0];
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof AtlEnthalteneObjekte) {
                AtlEnthalteneObjekte objekte = (AtlEnthalteneObjekte)parentElement;
                return new Object[]{new NamedFeld(RegionPage.BEREICHE, objekte, objekte.getBereich()), new NamedFeld(RegionPage.REGIONEN, objekte, objekte.getRegion()), new NamedFeld(RegionPage.OBJEKTE, objekte, objekte.getObjekte())};
            }
            if (parentElement instanceof AtlAusgeschlosseneObjekte) {
                AtlAusgeschlosseneObjekte objekte = (AtlAusgeschlosseneObjekte)parentElement;
                return new Object[]{new NamedFeld(RegionPage.BEREICHE, objekte, objekte.getBereich()), new NamedFeld(RegionPage.REGIONEN, objekte, objekte.getRegion()), new NamedFeld(RegionPage.OBJEKTE, objekte, objekte.getObjekte())};
            }
            if (parentElement instanceof AtlBereiche) {
                AtlBereiche atlBereiche = (AtlBereiche)parentElement;
                return new Object[]{new NamedFeld(RegionPage.KONFIGURATIONSVERANTWORTLICHE, parentElement, atlBereiche.getKonfigurationsverantwortlicher()), new NamedFeld(RegionPage.KONFIGURATIONSBEREICHE, parentElement, ((AtlBereiche)parentElement).getKonfigurationsbereich()), new NamedFeld(RegionPage.TYPEN, parentElement, ((AtlBereiche)parentElement).getTyp())};
            }
            if (parentElement instanceof AtlRegionen) {
                AtlRegionen region = (AtlRegionen)parentElement;
                return new Object[]{new NamedFeld(RegionPage.REGION, parentElement, region.getRegion()), new NamedFeld(RegionPage.TYPEN, parentElement, region.getTyp())};
            }
            if (parentElement instanceof AtlObjekte) {
                return ((AtlObjekte)parentElement).getObjekt().toArray();
            }
            if (parentElement instanceof Feld) {
                return ((Feld)parentElement).toArray();
            }
            return new Object[0];
        }
    }
}

