/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.benutzervew.handler;

import de.bsvrz.buv.plugin.benutzervew.data.Benutzer;
import de.bsvrz.buv.plugin.benutzervew.internal.RahmenwerkService;
import de.bsvrz.dav.daf.main.config.ConfigurationTaskException;
import de.bsvrz.dav.daf.main.config.management.UserAdministration;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class BenutzerEinmalPassworteAnzeigenHandler
extends AbstractHandler {
    public static final String COMMAND_ID = "de.bsvrz.buv.plugin.benutzervew.actions.BenutzerEinmalPassworteAnzeigenAktion";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Benutzer benutzer = this.getBenutzer(event);
        if (benutzer != null) {
            UserAdministration userAdministration = RahmenwerkService.getService().getRahmenWerk().getDavVerbindung().getDataModel().getUserAdministration();
            try {
                int[] singleServingPasswordId = userAdministration.getValidOneTimePasswordIDs(RahmenwerkService.getService().getRahmenWerk().getBenutzerName(), RahmenwerkService.getService().getRahmenWerk().getPasswort(), benutzer.getName());
                StringBuilder message = new StringBuilder(200);
                if (singleServingPasswordId.length > 0) {
                    message.append("F\u00fcr den Benutzer '");
                    message.append(benutzer.getName());
                    message.append("' sind noch ");
                    message.append(singleServingPasswordId.length);
                    message.append(" Einmal-Passworte verf\u00fcgbar\n");
                    message.append("Verf\u00fcgbar sind die ID: ");
                    int idx = 0;
                    while (idx < singleServingPasswordId.length) {
                        if (idx > 0) {
                            message.append(',');
                        }
                        message.append(singleServingPasswordId[idx]);
                        ++idx;
                    }
                } else {
                    message.append("F\u00fcr den Benutzer '");
                    message.append(benutzer.getName());
                    message.append("' sind keine Einmal-Passworte verf\u00fcgbar");
                }
                MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Einmal-Passworte", (String)message.toString());
            }
            catch (ConfigurationTaskException e) {
                MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"FEHLER", (String)("Informationen zu Einmal-Passworten konnte nicht ermittelt werden!\n" + e.getLocalizedMessage()));
            }
        }
        return null;
    }

    private Benutzer getBenutzer(ExecutionEvent event) {
        Object benutzer;
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection && (benutzer = ((IStructuredSelection)selection).getFirstElement()) instanceof Benutzer) {
            return (Benutzer)benutzer;
        }
        return null;
    }
}

