/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.benutzervew.handler;

import de.bsvrz.buv.plugin.benutzervew.data.Benutzer;
import de.bsvrz.buv.plugin.benutzervew.data.BenutzerChangeException;
import de.bsvrz.buv.plugin.benutzervew.data.KeineRechteException;
import de.bsvrz.buv.plugin.benutzervew.handler.BmvAdminHandler;
import de.bsvrz.buv.plugin.benutzervew.internal.RahmenwerkService;
import de.bsvrz.buv.rw.basislib.urlasser.UrlasserInfoDatenDialog;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;

public class BenutzerLoeschenHandler
extends BmvAdminHandler {
    public static final String COMMAND_ID = "de.bsvrz.buv.plugin.benutzervew.actions.BenutzerLoeschenAktion";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        if (!this.testeAdmin()) {
            return null;
        }
        Benutzer benutzer = this.getBenutzer(event);
        if (benutzer != null) {
            String name = benutzer.toString();
            if (MessageDialog.openQuestion((Shell)Display.getDefault().getActiveShell(), (String)"L\u00f6schen Benutzer", (String)("Soll der Benutzer: " + name + System.getProperty("line.separator") + "wirklich gel\u00f6scht werden ?"))) {
                UrlasserInfoDatenDialog dialog = new UrlasserInfoDatenDialog(new Shell(Display.getDefault()), (verbindung, urlasser) -> {
                    try {
                        RahmenwerkService.getService().getBenutzerverwaltung().entfernenBenutzer(urlasser.getBenutzerName(), urlasser.getPasswort(), benutzer);
                    }
                    catch (KeineRechteException e1) {
                        MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Fehler", (String)e1.getLocalizedMessage());
                    }
                    catch (BenutzerChangeException e2) {
                        MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Fehler", (String)(String.valueOf(e2.getLocalizedMessage()) + System.getProperty("line.separator") + System.getProperty("line.separator") + "Ursache: " + e2.getCause().getLocalizedMessage() + System.getProperty("line.separator") + "(m\u00f6glicher Grund: keine Rechte am konfigurierenden KB)"));
                    }
                });
                dialog.setInitialBenutzer(RahmenwerkService.getService().getRahmenWerk().getBenutzerName());
                dialog.setInitialVeranlasser(RahmenwerkService.getService().getRahmenWerk().getBenutzerName());
                dialog.setInitialUrsache("Benutzer '" + name + "' geloescht");
                dialog.open();
            }
        }
        return null;
    }

    private Benutzer getBenutzer(ExecutionEvent event) {
        Object benutzer;
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection && (benutzer = ((IStructuredSelection)selection).getFirstElement()) instanceof Benutzer) {
            return (Benutzer)benutzer;
        }
        return null;
    }
}

