/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.benutzervew.internal;

import de.bsvrz.buv.plugin.benutzervew.PluginBenutzerVew;
import de.bsvrz.buv.plugin.benutzervew.data.Benutzerverwaltung;
import de.bsvrz.buv.rw.basislib.Rahmenwerk;
import de.bsvrz.buv.rw.basislib.berechtigung.Berechtigungen;
import de.bsvrz.buv.rw.basislib.dav.DavVerbindungsEvent;
import de.bsvrz.buv.rw.basislib.dav.DavVerbindungsListener;
import de.bsvrz.sys.funclib.bitctrl.modell.ObjektFactory;
import de.bsvrz.sys.funclib.debug.Debug;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class RahmenwerkService {
    private static RahmenwerkService service;
    private Rahmenwerk rahmenWerk;
    private Berechtigungen berechtigungen;
    private final Benutzerverwaltung benutzerverwaltung = new Benutzerverwaltung();
    private ObjektFactory objektFactory;
    public static final int BENUTZERPASSWORT_MIN_LAENGE = 5;
    protected static final Debug LOGGER;

    static {
        LOGGER = Debug.getLogger();
    }

    public static RahmenwerkService getService() {
        return service;
    }

    protected void activate() {
        service = this;
    }

    protected void deactivate() {
        service = null;
    }

    protected void bindRahmenwerk(Rahmenwerk newRahmenWerk) {
        this.rahmenWerk = newRahmenWerk;
        this.rahmenWerk.addDavVerbindungsListener(new DavVerbindungsListener(){

            public void verbindungHergestellt(DavVerbindungsEvent event) {
                PluginBenutzerVew.getDefault().getLog().log((IStatus)new Status(1, "de.bsvrz.buv.plugin.benutzervew", "Initialisiere Berechtigungsverwaltung Benutzerverwaltung/Zugriffsrechte"));
                RahmenwerkService.this.benutzerverwaltung.connect(RahmenwerkService.this.rahmenWerk.getDavVerbindung());
            }

            public boolean verbindungHalten(DavVerbindungsEvent event) {
                return false;
            }

            public void verbindungGetrennt(DavVerbindungsEvent event) {
                PluginBenutzerVew.getDefault().getLogger().info("Benutzer-Plugin: Verbindung abgebaut");
                RahmenwerkService.this.benutzerverwaltung.disconnect();
            }
        });
    }

    protected void unbindRahmenwerk(Rahmenwerk newRahmenWerk) {
        this.rahmenWerk = null;
    }

    public Rahmenwerk getRahmenWerk() {
        return this.rahmenWerk;
    }

    protected void bindBerechtigungen(Berechtigungen newBerechtigungen) {
        this.berechtigungen = newBerechtigungen;
    }

    protected void unbindBerechtigungen(Berechtigungen newBerechtigungen) {
        this.berechtigungen = null;
    }

    public Berechtigungen getBerechtigungen() {
        return this.berechtigungen;
    }

    public Benutzerverwaltung getBenutzerverwaltung() {
        return this.benutzerverwaltung;
    }

    protected void bindObjektFactory(ObjektFactory objektFactory) {
        this.objektFactory = objektFactory;
    }

    protected void unbindObjektFactory(ObjektFactory objektFactory) {
        this.objektFactory = null;
    }

    public final ObjektFactory getObjektFactory() {
        return this.objektFactory;
    }
}

