/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.benutzervew.views;

import de.bsvrz.buv.plugin.benutzervew.PluginBenutzerVew;
import de.bsvrz.buv.plugin.benutzervew.actions.ViewAktualisierenAktion;
import de.bsvrz.buv.plugin.benutzervew.data.Benutzer;
import de.bsvrz.buv.plugin.benutzervew.data.BenutzerListener;
import de.bsvrz.buv.plugin.benutzervew.data.BerechtigungsKlasse;
import de.bsvrz.buv.plugin.benutzervew.data.DavVerbindungSwitcher;
import de.bsvrz.buv.plugin.benutzervew.data.DavVerbindungView;
import de.bsvrz.buv.plugin.benutzervew.internal.RahmenwerkService;
import de.bsvrz.buv.plugin.benutzervew.views.BenutzerContextMenu;
import de.bsvrz.buv.plugin.benutzervew.views.BenutzerListeLabelProvider;
import de.bsvrz.buv.plugin.benutzervew.views.BenutzerListeSorter;
import de.bsvrz.buv.plugin.benutzervew.views.BenutzerSpaltenSorter;
import de.bsvrz.buv.rw.basislib.dav.DavVerbindungsListener;
import de.bsvrz.buv.rw.basislib.printing.RwPrintable;
import de.bsvrz.dav.daf.main.ClientDavInterface;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.ResourceBundle;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.nebula.paperclips.core.BigPrint;
import org.eclipse.nebula.paperclips.core.ImagePrint;
import org.eclipse.nebula.paperclips.core.Print;
import org.eclipse.nebula.paperclips.core.border.Border;
import org.eclipse.nebula.paperclips.core.border.LineBorder;
import org.eclipse.nebula.paperclips.core.grid.DefaultGridLook;
import org.eclipse.nebula.paperclips.core.grid.GridColumn;
import org.eclipse.nebula.paperclips.core.grid.GridLook;
import org.eclipse.nebula.paperclips.core.grid.GridPrint;
import org.eclipse.nebula.paperclips.core.page.PagePrint;
import org.eclipse.nebula.paperclips.core.text.TextPrint;
import org.eclipse.nebula.paperclips.core.text.TextStyle;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class BenutzerListe
extends ViewPart
implements BenutzerListener,
RwPrintable,
DavVerbindungView {
    public static final String VIEW_ID = BenutzerListe.class.getName();
    private static final String HILFE_ID = "de.bsvrz.buv.plugin.benutzervew." + BenutzerListe.class.getSimpleName();
    private ResourceBundle resourceBundle;
    private final SpaltenDefinition[] spalten = new SpaltenDefinition[]{new SpaltenDefinition("Benutzerkennung", "Benutzerkennung", 200, SpaltenIndex.SPALTE_KENNUNG), new SpaltenDefinition("Berechtigungsklassen", "Berechtigungsklassen", 200, SpaltenIndex.SPALTE_BENUTZERKLASSE), new SpaltenDefinition("Name", "Name", 200, SpaltenIndex.SPALTE_NAME), new SpaltenDefinition("Vorname", "Vorname", 200, SpaltenIndex.SPALTE_VORNAME), new SpaltenDefinition("Zweiter Vorname", "Zweiter Vorname", 200, SpaltenIndex.SPALTE_ZWEITERVORNAME), new SpaltenDefinition("Organisation", "Organisation", 200, SpaltenIndex.SPALTE_ORGANISATION), new SpaltenDefinition("E-Mail", "E-Mail", 200, SpaltenIndex.SPALTE_EMAIL)};
    private boolean filterDeactivated = true;
    private BenutzerListeSorter sorter;
    private TableViewer viewer;
    private DavVerbindungSwitcher verbindungsListener;

    public TableViewer getViewer() {
        return this.viewer;
    }

    public void createPartControl(Composite parent) {
        this.resourceBundle = PluginBenutzerVew.getDefault().getResourceBundle();
        this.viewer = new TableViewer(parent, 66308);
        this.getViewSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.createContextMenu();
        this.sorter = new BenutzerListeSorter(false);
        this.viewer.getTable().setHeaderVisible(true);
        this.viewer.getTable().setLinesVisible(true);
        SpaltenDefinition[] spaltenDefinitionArray = this.spalten;
        int n = this.spalten.length;
        int n2 = 0;
        while (n2 < n) {
            SpaltenDefinition def = spaltenDefinitionArray[n2];
            this.createTableColumn(this.viewer.getTable(), SpaltenIndex.valueOf(def.spaltenindex.name()).ordinal(), def.spaltenname, def.tooltip, true, 16384, def.breite, false, this.getSorter(def.spaltenindex));
            ++n2;
        }
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new BenutzerListeLabelProvider());
        this.sorter.resetState();
        IActionBars bars = this.getViewSite().getActionBars();
        IToolBarManager toolbar = bars.getToolBarManager();
        toolbar.add((IAction)new ViewAktualisierenAktion((Viewer)this.viewer));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, HILFE_ID);
        this.verbindungsListener = new DavVerbindungSwitcher(this);
        RahmenwerkService.getService().getRahmenWerk().addDavVerbindungsListener((DavVerbindungsListener)this.verbindungsListener);
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.setDav(RahmenwerkService.getService().getRahmenWerk().getDavVerbindung());
        RahmenwerkService.getService().getBenutzerverwaltung().addBenutzerListener(this);
    }

    private BenutzerSpaltenSorter getSorter(SpaltenIndex index) {
        if (index == SpaltenIndex.SPALTE_KENNUNG) {
            return new BenutzerSpaltenSorter((o1, o2) -> o1.getName().compareToIgnoreCase(o2.getName()));
        }
        if (index == SpaltenIndex.SPALTE_BENUTZERKLASSE) {
            return new BenutzerSpaltenSorter((o1, o2) -> o1.getBerechtigungsKlassenAsString().compareToIgnoreCase(o2.getBerechtigungsKlassenAsString()));
        }
        if (index == SpaltenIndex.SPALTE_NAME) {
            return new BenutzerSpaltenSorter((o1, o2) -> o1.getNachname().compareToIgnoreCase(o2.getNachname()));
        }
        if (index == SpaltenIndex.SPALTE_VORNAME) {
            return new BenutzerSpaltenSorter((o1, o2) -> o1.getVorname().compareToIgnoreCase(o2.getVorname()));
        }
        if (index == SpaltenIndex.SPALTE_ZWEITERVORNAME) {
            return new BenutzerSpaltenSorter((o1, o2) -> o1.getZweiterVorname().compareToIgnoreCase(o2.getZweiterVorname()));
        }
        if (index == SpaltenIndex.SPALTE_ORGANISATION) {
            return new BenutzerSpaltenSorter((o1, o2) -> o1.getOrganisation().compareToIgnoreCase(o2.getOrganisation()));
        }
        if (index == SpaltenIndex.SPALTE_EMAIL) {
            return new BenutzerSpaltenSorter((o1, o2) -> o1.getEmailAdresse().compareToIgnoreCase(o2.getEmailAdresse()));
        }
        return null;
    }

    public boolean isFilterDeactivated() {
        return this.filterDeactivated;
    }

    private TableColumn createTableColumn(final Table parent, final int spaltenindex, String name, String tooltip, boolean resizable, int alignment, int width, boolean createMenuEntry, BenutzerSpaltenSorter columnSorter) {
        this.sorter.addTableColumnSorter(spaltenindex, columnSorter);
        TableColumn column = new TableColumn(parent, alignment);
        column.setText(name);
        column.setToolTipText(tooltip);
        column.setWidth(width);
        column.setResizable(resizable);
        column.setMoveable(false);
        column.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Cursor loadCursor = new Cursor((Device)parent.getDisplay(), 1);
                parent.setCursor(loadCursor);
                BenutzerListe.this.sorter.setColumn(spaltenindex);
                BenutzerListe.this.sortTable();
                parent.setCursor(null);
                loadCursor.dispose();
            }
        });
        return column;
    }

    private void createContextMenu() {
        BenutzerContextMenu menuMgr = new BenutzerContextMenu((StructuredViewer)this.viewer);
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getViewSite().registerContextMenu((MenuManager)menuMgr, (ISelectionProvider)this.viewer);
    }

    private void sortTable() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        ArrayList input = new ArrayList((Collection)this.viewer.getInput());
        Collections.sort(input, this.sorter);
        this.viewer.setInput(input);
        this.updateSortIndicator();
        if (!input.isEmpty()) {
            if (selection.isEmpty()) {
                selection = new StructuredSelection(input.get(0));
            }
            this.viewer.setSelection((ISelection)selection);
        }
    }

    private void updateSortIndicator() {
        this.viewer.getTable().setSortColumn(this.viewer.getTable().getColumn(this.sorter.getColumn()));
        this.viewer.getTable().setSortDirection(this.sorter.getDirection(this.sorter.getColumn()) == BenutzerListeSorter.Direction.ASCENDING ? 128 : 1024);
    }

    public BerechtigungsKlasse getSelectedBerechtigungsklasse() {
        Object obj;
        if (this.viewer.getSelection() != null && (obj = ((StructuredSelection)this.viewer.getSelection()).getFirstElement()) instanceof BerechtigungsKlasse) {
            return (BerechtigungsKlasse)obj;
        }
        return null;
    }

    public Benutzer getSelectedBenutzer() {
        Object obj;
        if (this.viewer.getSelection() != null && (obj = ((StructuredSelection)this.viewer.getSelection()).getFirstElement()) instanceof Benutzer) {
            return (Benutzer)obj;
        }
        return null;
    }

    public void setFilterDeactivated(boolean filterDeactivated) {
        this.filterDeactivated = filterDeactivated;
        this.viewer.refresh();
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public void aktualisieren() {
        if (this.viewer != null && !this.viewer.getControl().isDisposed()) {
            Display.getDefault().asyncExec(() -> {
                if (this.viewer != null && !this.viewer.getControl().isDisposed() && RahmenwerkService.getService().getBenutzerverwaltung() != null) {
                    this.viewer.setInput(RahmenwerkService.getService().getBenutzerverwaltung().getBenutzer());
                    this.sortTable();
                }
            });
        }
    }

    public PagePrint getDruckAuftrag() {
        String header = this.resourceBundle.getString("BenutzerlisteDruck.header");
        GridPrint grid = new GridPrint();
        grid.addColumn(new GridColumn(16384, -1, 0));
        grid.add((Print)new TextPrint(header, new FontData("Arial", 14, 1)));
        GridPrint tabelle = new GridPrint();
        DefaultGridLook look = new DefaultGridLook();
        look.setHeaderBackground(new RGB(200, 200, 200));
        TextStyle textStyle = new TextStyle();
        TextStyle headerStyle = textStyle.font("Arial", 10, 1);
        textStyle = textStyle.font("Arial", 10, 0);
        look.setCellBorder((Border)new LineBorder(new RGB(0, 0, 0)));
        tabelle.setLook((GridLook)look);
        TableViewer tviewer = this.viewer;
        TableColumn[] tableColumnArray = tviewer.getTable().getColumns();
        int n = tableColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn column = tableColumnArray[n2];
            GridColumn gridColumn = new GridColumn(16384, -1, 1);
            tabelle.addColumn(gridColumn);
            tabelle.addHeader((Print)headerStyle.create(column.getText()));
            ++n2;
        }
        tableColumnArray = tviewer.getTable().getItems();
        n = tableColumnArray.length;
        n2 = 0;
        while (n2 < n) {
            TableColumn item = tableColumnArray[n2];
            int colIdx = 0;
            while (colIdx < tviewer.getTable().getColumns().length) {
                Image image = item.getImage(colIdx);
                if (image != null) {
                    tabelle.add((Print)new ImagePrint(image.getImageData()));
                } else {
                    tabelle.add((Print)textStyle.create(item.getText(colIdx)));
                }
                ++colIdx;
            }
            ++n2;
        }
        grid.add((Print)tabelle);
        return new PagePrint((Print)new BigPrint((Print)grid));
    }

    public String getTitel() {
        return this.resourceBundle.getString("BenutzerlisteDruck.titel");
    }

    @Override
    public void benutzerAdded(Benutzer benutzer) {
        Display.getDefault().asyncExec(() -> {
            this.viewer.setInput(RahmenwerkService.getService().getBenutzerverwaltung().getBenutzer());
            this.sortTable();
        });
    }

    @Override
    public void benutzerRemoved(Benutzer benutzer) {
        Display.getDefault().asyncExec(() -> {
            this.viewer.setInput(RahmenwerkService.getService().getBenutzerverwaltung().getBenutzer());
            this.sortTable();
        });
    }

    @Override
    public void benutzerChanged(Benutzer benutzer) {
        Display.getDefault().asyncExec(() -> this.viewer.refresh((Object)benutzer));
    }

    public void dispose() {
        RahmenwerkService.getService().getRahmenWerk().removeDavVerbindungsListener((DavVerbindungsListener)this.verbindungsListener);
        super.dispose();
    }

    @Override
    public void setDav(ClientDavInterface dav) {
        if (dav == null) {
            this.setContentDescription(this.resourceBundle.getString("OfflineMeldung.label"));
            this.viewer.setInput(null);
            this.viewer.getControl().setEnabled(false);
        } else {
            this.setContentDescription("");
            this.viewer.setInput(RahmenwerkService.getService().getBenutzerverwaltung().getBenutzer());
            this.viewer.getControl().setEnabled(true);
        }
        this.viewer.refresh();
    }

    private static class SpaltenDefinition {
        private final String spaltenname;
        private final String tooltip;
        private final int breite;
        private final SpaltenIndex spaltenindex;

        SpaltenDefinition(String spaltenname, String tooltip, int breite, SpaltenIndex spalteKennung) {
            this.spaltenname = spaltenname;
            this.tooltip = tooltip;
            this.breite = breite;
            this.spaltenindex = spalteKennung;
        }
    }

    public static enum SpaltenIndex {
        SPALTE_KENNUNG,
        SPALTE_BENUTZERKLASSE,
        SPALTE_NAME,
        SPALTE_VORNAME,
        SPALTE_ZWEITERVORNAME,
        SPALTE_ORGANISATION,
        SPALTE_EMAIL;

    }
}

