/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.benutzervew.views;

import de.bsvrz.buv.plugin.benutzervew.views.IBenutzerSorter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BenutzerListeSorter
implements IBenutzerSorter,
Comparator<Object> {
    private List<Integer> columnsList;
    private Direction[] directions;
    private final Map<Integer, IBenutzerSorter> sorterMap;
    private final Map<Integer, Direction> defaultDirectionMap;
    private final Map<Integer, Integer> columnPriorityMap;
    private int maxColumnNumber;
    private Integer[] defaultColumnSorting;
    private Direction[] defaultDirections;

    public BenutzerListeSorter(boolean reset) {
        if (reset) {
            this.resetState();
        }
        this.sorterMap = new HashMap<Integer, IBenutzerSorter>();
        this.defaultDirectionMap = new HashMap<Integer, Direction>();
        this.columnPriorityMap = new HashMap<Integer, Integer>();
    }

    public void resetState() {
        if (this.defaultColumnSorting == null || this.defaultDirections == null) {
            this.determineDefaultColumnSorting();
            this.determineDefaultDirections();
        }
        this.directions = new Direction[this.getDefaultDirections().length];
        System.arraycopy(this.getDefaultDirections(), 0, this.directions, 0, this.directions.length);
        this.columnsList = new ArrayList<Integer>(Arrays.asList(this.getDefaultColumnSorting()));
    }

    public void setColumn(int column) {
        try {
            if (this.columnsList.get(0) != column) {
                this.columnsList.remove((Object)column);
                this.columnsList.add(0, column);
                this.setDirection(column, Direction.ASCENDING);
            } else {
                this.reverseDirection(column);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setDirection(int column, Direction direction) {
        this.directions[column] = direction;
    }

    public Direction getDirection(int column) {
        return this.directions[column];
    }

    public int getColumn() {
        return this.columnsList.get(0);
    }

    private void reverseDirection(int column) {
        this.directions[column] = this.directions[column].getInvert();
    }

    @Override
    public int compare(Object e1, Object e2) {
        for (Integer integer : this.columnsList) {
            int column = integer;
            int result = this.compare(column, e1, e2);
            if (result == 0) continue;
            return result;
        }
        return 0;
    }

    public void addTableColumnSorter(int column, IBenutzerSorter sorter) {
        if (sorter == null) {
            return;
        }
        Direction defaultDirection = sorter.getDefaultDirection();
        int columnPriority = sorter.getColumnPriority();
        this.maxColumnNumber = column > this.maxColumnNumber ? column : this.maxColumnNumber;
        this.sorterMap.put(column < 0 ? 0 : column, sorter);
        this.defaultDirectionMap.put(column < 0 ? 0 : column, defaultDirection);
        this.columnPriorityMap.put(column < 0 ? 0 : column, columnPriority < 0 ? 0 : (columnPriority > 10 ? 10 : columnPriority));
    }

    private void determineDefaultColumnSorting() {
        ArrayList<Map.Entry<Integer, Integer>> entries = new ArrayList<Map.Entry<Integer, Integer>>(this.columnPriorityMap.entrySet());
        Collections.sort(entries, (o1, o2) -> -1 * ((Integer)o1.getValue()).compareTo((Integer)o2.getValue()));
        this.defaultColumnSorting = new Integer[entries.size()];
        int i = 0;
        while (i < entries.size()) {
            this.defaultColumnSorting[i] = (Integer)((Map.Entry)entries.get(i)).getKey();
            ++i;
        }
    }

    private void determineDefaultDirections() {
        this.defaultDirections = new Direction[this.maxColumnNumber + 1];
        int i = 0;
        while (i <= this.maxColumnNumber) {
            Direction direction = this.defaultDirectionMap.get(i);
            this.defaultDirections[i] = direction != null ? direction : Direction.ASCENDING;
            ++i;
        }
    }

    protected Integer[] getDefaultColumnSorting() {
        return this.defaultColumnSorting;
    }

    protected Direction[] getDefaultDirections() {
        return this.defaultDirections;
    }

    public int compare(int column, Object o1, Object o2) {
        IBenutzerSorter sorter = this.sorterMap.get(column);
        return sorter != null ? this.getDirection(column).getValue() * sorter.compare(o1, o2) : 0;
    }

    @Override
    public int getColumnPriority() {
        return 0;
    }

    @Override
    public Direction getDefaultDirection() {
        return null;
    }

    public static enum Direction {
        ASCENDING(1),
        DESCENDING(-1);

        private int value;

        private Direction(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public Direction getInvert() {
            if (this == ASCENDING) {
                return DESCENDING;
            }
            return ASCENDING;
        }
    }
}

