/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.benutzervew.views;

import de.bsvrz.buv.plugin.benutzervew.PluginBenutzerVew;
import de.bsvrz.buv.plugin.benutzervew.actions.ViewAktualisierenAktion;
import de.bsvrz.buv.plugin.benutzervew.data.Benutzer;
import de.bsvrz.buv.plugin.benutzervew.data.BenutzerListener;
import de.bsvrz.buv.plugin.benutzervew.data.BerechtigungsKlasse;
import de.bsvrz.buv.plugin.benutzervew.data.DavVerbindungSwitcher;
import de.bsvrz.buv.plugin.benutzervew.data.DavVerbindungView;
import de.bsvrz.buv.plugin.benutzervew.internal.RahmenwerkService;
import de.bsvrz.buv.plugin.benutzervew.views.BenutzerContextMenu;
import de.bsvrz.buv.plugin.benutzervew.views.BenutzerNavigatorContentProvider;
import de.bsvrz.buv.plugin.benutzervew.views.BenutzerNavigatorLabelProvider;
import de.bsvrz.buv.rw.basislib.dav.DavVerbindungsListener;
import de.bsvrz.dav.daf.main.ClientDavInterface;
import java.util.ResourceBundle;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.part.ViewPart;

public class BenutzerNavigator
extends ViewPart
implements BenutzerListener,
DavVerbindungView {
    public static final String VIEW_ID = BenutzerNavigator.class.getName();
    private static final String HILFE_ID = "de.bsvrz.buv.plugin.benutzervew." + BenutzerNavigator.class.getSimpleName();
    private ResourceBundle resourceBundle;
    private Composite container;
    private TreeViewer treeViewer;
    private Text filterText;
    private DavVerbindungSwitcher verbindungsListener;

    public void createPartControl(Composite parent) {
        this.container = new Composite(parent, 0);
        this.container.setLayout((Layout)new GridLayout());
        this.resourceBundle = PluginBenutzerVew.getDefault().getResourceBundle();
        FormToolkit toolkit = new FormToolkit(parent.getDisplay());
        this.filterText = toolkit.createText(this.container, "", 2052);
        this.filterText.setMessage("Text zum Filtern eingeben");
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.filterText);
        this.treeViewer = new TreeViewer(this.container, 4);
        this.treeViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        PatternFilter filter = new PatternFilter();
        this.treeViewer.addFilter((ViewerFilter)filter);
        this.filterText.addModifyListener(event -> {
            filter.setPattern(this.filterText.getText());
            this.treeViewer.refresh();
        });
        this.treeViewer.setContentProvider((IContentProvider)new BenutzerNavigatorContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new BenutzerNavigatorLabelProvider());
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.treeViewer, (int)2);
        this.getSite().setSelectionProvider((ISelectionProvider)this.treeViewer);
        IActionBars bars = this.getViewSite().getActionBars();
        IToolBarManager toolbar = bars.getToolBarManager();
        toolbar.add((IAction)new AllesAufklappenAction());
        toolbar.add((IAction)new AllesZusammenKlappenAction());
        toolbar.add((IAction)new ViewSortierenAktion(this.treeViewer));
        toolbar.add((IAction)new ViewAktualisierenAktion((Viewer)this.treeViewer));
        this.createContextMenu();
        this.treeViewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (((TreeViewer)viewer).getTree().getSortDirection() == 1024) {
                    return super.compare(viewer, (Object)e2.toString().toLowerCase(), (Object)e1.toString().toLowerCase());
                }
                return super.compare(viewer, (Object)e1.toString().toLowerCase(), (Object)e2.toString().toLowerCase());
            }
        });
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.treeViewer.getTree(), HILFE_ID);
        this.getSite().setSelectionProvider((ISelectionProvider)this.treeViewer);
        this.verbindungsListener = new DavVerbindungSwitcher(this);
        RahmenwerkService.getService().getRahmenWerk().addDavVerbindungsListener((DavVerbindungsListener)this.verbindungsListener);
        this.setDav(RahmenwerkService.getService().getRahmenWerk().getDavVerbindung());
        RahmenwerkService.getService().getBenutzerverwaltung().addBenutzerListener(this);
    }

    private void createContextMenu() {
        BenutzerContextMenu menuMgr = new BenutzerContextMenu((StructuredViewer)this.treeViewer);
        Menu menu = menuMgr.createContextMenu(this.treeViewer.getControl());
        this.treeViewer.getControl().setMenu(menu);
        this.getViewSite().registerContextMenu((MenuManager)menuMgr, (ISelectionProvider)this.treeViewer);
    }

    public void setFocus() {
        if (this.treeViewer != null && !this.treeViewer.getControl().isDisposed()) {
            this.treeViewer.getControl().setFocus();
        }
    }

    public void dispose() {
        RahmenwerkService.getService().getRahmenWerk().removeDavVerbindungsListener((DavVerbindungsListener)this.verbindungsListener);
        super.dispose();
    }

    public BerechtigungsKlasse getSelectedBerechtigungsklasse() {
        Object obj;
        if (this.treeViewer.getSelection() != null && (obj = ((StructuredSelection)this.treeViewer.getSelection()).getFirstElement()) instanceof BerechtigungsKlasse) {
            return (BerechtigungsKlasse)obj;
        }
        return null;
    }

    public void aktualisieren(Object obj) {
        if (this.treeViewer != null && !this.treeViewer.getControl().isDisposed()) {
            if (obj != null) {
                this.treeViewer.refresh(obj);
            } else {
                this.treeViewer.refresh();
            }
        }
    }

    public void aktualisieren() {
        this.aktualisieren(null);
    }

    @Override
    public void benutzerAdded(Benutzer benutzer) {
        Display.getDefault().asyncExec(() -> benutzer.getBerechtigungsKlassen().stream().forEach(klasse -> this.aktualisieren(klasse)));
    }

    @Override
    public void benutzerRemoved(Benutzer benutzer) {
        Display.getDefault().asyncExec(() -> benutzer.getBerechtigungsKlassen().stream().forEach(klasse -> this.aktualisieren(klasse)));
    }

    @Override
    public void benutzerChanged(Benutzer benutzer) {
        Display.getDefault().asyncExec(() -> this.aktualisieren());
    }

    @Override
    public void setDav(ClientDavInterface dav) {
        if (dav == null) {
            this.setContentDescription(this.resourceBundle.getString("OfflineMeldung.label"));
            this.treeViewer.setInput(null);
            this.treeViewer.getControl().setEnabled(false);
        } else {
            this.setContentDescription("");
            this.treeViewer.setInput((Object)RahmenwerkService.getService().getBenutzerverwaltung());
            this.treeViewer.getControl().setEnabled(true);
        }
        this.aktualisieren();
    }

    private class AllesAufklappenAction
    extends Action {
        AllesAufklappenAction() {
            this.setText(BenutzerNavigator.this.resourceBundle.getString("BenutzerViewMenuExpandAll.label"));
            this.setToolTipText(BenutzerNavigator.this.resourceBundle.getString("BenutzerViewMenuExpandAll.tooltip"));
            this.setImageDescriptor(PluginBenutzerVew.getDefault().getImageDescriptor("icons/alles_aufklappen.gif"));
        }

        public void run() {
            BenutzerNavigator.this.treeViewer.expandAll();
        }
    }

    private class AllesZusammenKlappenAction
    extends Action {
        AllesZusammenKlappenAction() {
            this.setText(BenutzerNavigator.this.resourceBundle.getString("BenutzerViewMenuCollapseAll.label"));
            this.setToolTipText(BenutzerNavigator.this.resourceBundle.getString("BenutzerViewMenuCollapseAll.tooltip"));
            this.setImageDescriptor(PluginBenutzerVew.getDefault().getImageDescriptor("icons/alles_zusammenklappen.gif"));
        }

        public void run() {
            BenutzerNavigator.this.treeViewer.collapseAll();
        }
    }

    private static final class ViewSortierenAktion
    extends Action {
        private final TreeViewer viewer;

        ViewSortierenAktion(TreeViewer viewer) {
            super("Ansicht sortieren");
            this.setToolTipText("Sortiert die Ansicht");
            this.setImageDescriptor(PluginBenutzerVew.getDefault().getImageDescriptor("icons/alphab_sort_co.gif"));
            this.viewer = viewer;
        }

        public void runWithEvent(Event event) {
            Tree tree = this.viewer.getTree();
            if (tree.getSortDirection() == 1024) {
                tree.setSortDirection(128);
            } else {
                tree.setSortDirection(1024);
            }
            this.viewer.refresh();
        }
    }
}

