/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.benutzervew.views;

import de.bsvrz.buv.plugin.benutzervew.PluginBenutzerVew;
import de.bsvrz.buv.plugin.benutzervew.data.AngemeldeteApplikation;
import de.bsvrz.buv.plugin.benutzervew.data.Benutzer;
import de.bsvrz.buv.plugin.benutzervew.data.Benutzerverwaltung;
import de.bsvrz.buv.plugin.benutzervew.data.BerechtigungsKlasse;
import de.bsvrz.buv.plugin.benutzervew.data.RolleRegionPaar;
import de.bsvrz.buv.plugin.benutzervew.internal.RahmenwerkService;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.PlatformUI;

public class BenutzerNavigatorLabelProvider
extends CellLabelProvider
implements IColorProvider,
ILabelProvider {
    private static final Color OFFLINECOLOR;
    private static final Color ONLINECOLOR;
    private final Map<ImageDescriptor, Image> imageCache = new HashMap<ImageDescriptor, Image>();

    static {
        ColorRegistry cr = JFaceResources.getColorRegistry();
        cr.put(String.valueOf(BenutzerNavigatorLabelProvider.class.getName()) + ".OFFLINECOLOR", new RGB(128, 128, 128));
        cr.put(String.valueOf(BenutzerNavigatorLabelProvider.class.getName()) + ".ONLINECOLOR", new RGB(0, 0, 0));
        OFFLINECOLOR = JFaceResources.getColorRegistry().get(String.valueOf(BenutzerNavigatorLabelProvider.class.getName()) + ".OFFLINECOLOR");
        ONLINECOLOR = JFaceResources.getColorRegistry().get(String.valueOf(BenutzerNavigatorLabelProvider.class.getName()) + ".ONLINECOLOR");
    }

    public String getText(Object element) {
        if (element instanceof BerechtigungsKlasse) {
            BerechtigungsKlasse klasse = (BerechtigungsKlasse)element;
            return klasse.getName();
        }
        if (element instanceof Benutzer) {
            Benutzerverwaltung bv = RahmenwerkService.getService().getBenutzerverwaltung();
            Benutzer benutzer = (Benutzer)element;
            String s = benutzer.getName();
            if (bv.isAngemeldet(benutzer)) {
                s = String.valueOf(s) + "(angemeldet)";
            }
            return s;
        }
        return element.toString();
    }

    public Image getImage(Object obj) {
        ImageDescriptor descriptor = null;
        if (obj instanceof Benutzer) {
            descriptor = PluginBenutzerVew.getDefault().getImageDescriptor("icons/user.png");
        } else if (obj instanceof BerechtigungsKlasse) {
            descriptor = PluginBenutzerVew.getDefault().getImageDescriptor("icons/users.png");
        }
        Image image = null;
        if (descriptor == null) {
            String imageKey = "IMG_OBJ_FILE";
            image = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE");
        } else {
            image = this.imageCache.get(descriptor);
            if (image == null) {
                image = descriptor.createImage();
                this.imageCache.put(descriptor, image);
            }
        }
        return image;
    }

    public void dispose() {
        for (Image img : this.imageCache.values()) {
            img.dispose();
        }
        this.imageCache.clear();
    }

    public Color getBackground(Object element) {
        return null;
    }

    public Color getForeground(Object element) {
        if (element instanceof Benutzer) {
            Benutzer benutzer;
            Benutzerverwaltung bv = RahmenwerkService.getService().getBenutzerverwaltung();
            if (bv.isAngemeldet(benutzer = (Benutzer)element)) {
                return ONLINECOLOR;
            }
            return OFFLINECOLOR;
        }
        return null;
    }

    public void update(ViewerCell cell) {
        cell.setText(this.getText(cell.getElement()));
        cell.setImage(this.getImage(cell.getElement()));
        cell.setForeground(this.getForeground(cell.getElement()));
        cell.setBackground(this.getBackground(cell.getElement()));
    }

    public String getToolTipText(Object element) {
        String ls = System.getProperty("line.separator");
        if (element instanceof BerechtigungsKlasse) {
            Collection<RolleRegionPaar> rolleRegionenPaare;
            BerechtigungsKlasse klasse = (BerechtigungsKlasse)element;
            StringBuffer s = new StringBuffer();
            s.append("Berechtigungsklasse: ");
            s.append(klasse.getName());
            s.append(" (");
            s.append(klasse.getPid());
            s.append(')');
            if (!klasse.getKurzInfo().isEmpty()) {
                s.append(ls);
                s.append(klasse.getKurzInfo());
            }
            if (!(rolleRegionenPaare = klasse.getRolleRegionenPaare()).isEmpty()) {
                s.append(ls);
                s.append("Rollen-/Regionenpaare:");
                for (RolleRegionPaar paar : rolleRegionenPaare) {
                    s.append(ls);
                    s.append(paar.getRolle().getName());
                    s.append('/');
                    s.append(paar.getRegion().getName());
                }
            }
            return s.toString();
        }
        if (element instanceof Benutzer) {
            Benutzerverwaltung bv = RahmenwerkService.getService().getBenutzerverwaltung();
            Benutzer benutzer = (Benutzer)element;
            StringBuffer s = new StringBuffer();
            s.append("Benutzer: ");
            s.append(benutzer.getName());
            s.append(" (");
            s.append(benutzer.getPid());
            s.append(')');
            if (!benutzer.getKurzInfo().isEmpty()) {
                s.append(ls);
                s.append(benutzer.getKurzInfo());
            }
            s.append(ls);
            s.append("Name: ");
            s.append(benutzer.getNachname());
            s.append(ls);
            s.append("Vorname: ");
            s.append(benutzer.getVorname());
            s.append(ls);
            s.append("Zweiter Vorname: ");
            s.append(benutzer.getZweiterVorname());
            s.append(ls);
            s.append("Organisation: ");
            s.append(benutzer.getOrganisation());
            s.append(ls);
            s.append("E-Mail: ");
            s.append(benutzer.getEmailAdresse());
            List<AngemeldeteApplikation> anmeldungen = bv.getAnmeldungen(benutzer);
            if (!anmeldungen.isEmpty()) {
                s.append(ls);
                s.append("angemeldet:");
                for (AngemeldeteApplikation app : anmeldungen) {
                    s.append(ls);
                    s.append(app.getName());
                    s.append(" / online seit ");
                    s.append(app.getAnmeldeZeit());
                }
            }
            return s.toString();
        }
        return element.toString();
    }

    public int getToolTipDisplayDelayTime(Object object) {
        return 1000;
    }
}

