/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.benutzervew.views;

import de.bsvrz.buv.plugin.benutzervew.data.Benutzer;
import de.bsvrz.buv.plugin.benutzervew.data.Benutzerverwaltung;
import de.bsvrz.buv.plugin.benutzervew.data.BerechtigungsKlasse;
import de.bsvrz.buv.plugin.benutzervew.internal.RahmenwerkService;
import de.bsvrz.buv.plugin.benutzervew.views.BenutzerListeSorter;
import de.bsvrz.buv.plugin.benutzervew.views.IBenutzerSorter;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;

public class BenutzerNavigatorSorter
extends ViewerComparator
implements IBenutzerSorter {
    private final BenutzerListeSorter.Direction defaultDirection = BenutzerListeSorter.Direction.ASCENDING;
    private BenutzerListeSorter.Direction richtungView;
    private final Map<BerechtigungsKlasse, BenutzerListeSorter.Direction> sortMap = new HashMap<BerechtigungsKlasse, BenutzerListeSorter.Direction>();

    public BenutzerNavigatorSorter() {
        this.richtungView = this.defaultDirection;
    }

    @Override
    public int compare(Object o1, Object o2) {
        if (o1 instanceof BerechtigungsKlasse) {
            return this.sortiereKlassen(o1, o2);
        }
        return this.sortiereKlasse(o1, o2);
    }

    private int sortiereKlassen(Object o1, Object o2) {
        Comparator comp = this.getComparator();
        if (o1 instanceof BerechtigungsKlasse && o2 instanceof BerechtigungsKlasse) {
            if (this.richtungView == BenutzerListeSorter.Direction.ASCENDING) {
                return comp.compare(o1.toString(), o2.toString());
            }
            return comp.compare(o2.toString(), o1.toString());
        }
        return 0;
    }

    private int sortiereKlasse(Object o1, Object o2) {
        Comparator comp = this.getComparator();
        if (o1 instanceof Benutzer && o2 instanceof Benutzer) {
            Benutzerverwaltung benutzerverwaltung = RahmenwerkService.getService().getBenutzerverwaltung();
            BerechtigungsKlasse klasse = benutzerverwaltung.getBerechtigungsklasse((Benutzer)o1);
            if (this.sortMap.get(klasse) == null) {
                this.sortMap.put(klasse, this.defaultDirection);
            }
            if (this.sortMap.get(klasse) == BenutzerListeSorter.Direction.ASCENDING) {
                return comp.compare(o1.toString(), o2.toString());
            }
            return comp.compare(o2.toString(), o1.toString());
        }
        return 0;
    }

    public void richtungViewUmkehren() {
        this.richtungView = this.richtungView == BenutzerListeSorter.Direction.ASCENDING ? BenutzerListeSorter.Direction.DESCENDING : BenutzerListeSorter.Direction.ASCENDING;
    }

    public void richtungKlasseUmkehren(BerechtigungsKlasse klasse) {
        if (this.sortMap.get(klasse) == null) {
            this.sortMap.put(klasse, this.defaultDirection);
        } else {
            this.sortMap.put(klasse, this.sortMap.get(klasse) == BenutzerListeSorter.Direction.ASCENDING ? BenutzerListeSorter.Direction.DESCENDING : BenutzerListeSorter.Direction.ASCENDING);
        }
    }

    @Override
    public int getColumnPriority() {
        return 0;
    }

    @Override
    public BenutzerListeSorter.Direction getDefaultDirection() {
        return this.defaultDirection;
    }

    public int compare(Viewer viewer, Object o1, Object o2) {
        return this.compare(o1, o2);
    }
}

