/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.benutzervew.views;

import de.bsvrz.buv.plugin.benutzervew.data.Region;
import de.bsvrz.buv.plugin.benutzervew.internal.RahmenwerkService;
import de.bsvrz.buv.rw.basislib.dav.DavVerbindungsEvent;
import de.bsvrz.buv.rw.basislib.dav.DavVerbindungsListener;
import de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte.ZugriffsRegionNeu;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.part.ViewPart;

public class RegionenView
extends ViewPart {
    public static final String ID = "de.bsvrz.buv.plugin.benutzervew.view.regionen";
    private TableViewer viewer;
    private final VerbindungsListener verbindungsListener = new VerbindungsListener();

    public void createPartControl(Composite parent) {
        Composite tableComposite = new Composite(parent, 0);
        TableColumnLayout tableColumnLayout = new TableColumnLayout();
        tableComposite.setLayout((Layout)tableColumnLayout);
        this.viewer = new TableViewer(tableComposite, 66308);
        Table table = this.viewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.viewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        TableViewerColumn colName = new TableViewerColumn(this.viewer, 0);
        tableColumnLayout.setColumnData((Widget)colName.getColumn(), (ColumnLayoutData)new ColumnWeightData(150, 200, true));
        colName.getColumn().setText("Name");
        colName.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof ZugriffsRegionNeu) {
                    return ((ZugriffsRegionNeu)element).getName();
                }
                return super.getText(element);
            }
        });
        TableViewerColumn colPid = new TableViewerColumn(this.viewer, 0);
        tableColumnLayout.setColumnData((Widget)colPid.getColumn(), (ColumnLayoutData)new ColumnWeightData(150, 200, true));
        colPid.getColumn().setText("Pid");
        colPid.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof ZugriffsRegionNeu) {
                    return ((ZugriffsRegionNeu)element).getPid();
                }
                return super.getText(element);
            }
        });
        RahmenwerkService service = RahmenwerkService.getService();
        service.getRahmenWerk().addDavVerbindungsListener((DavVerbindungsListener)this.verbindungsListener);
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        Collection<Region> regionen = RahmenwerkService.getService().getBenutzerverwaltung().getRegionen();
        List collect = regionen.stream().map(r -> service.getObjektFactory().getModellobjekt(r.getSystemObject())).collect(Collectors.toList());
        this.viewer.setInput(collect);
        MenuManager menuManager = new MenuManager("#PopupMenu");
        Menu menu = menuManager.createContextMenu((Control)parent);
        this.viewer.getControl().setMenu(menu);
        this.getViewSite().registerContextMenu(menuManager, (ISelectionProvider)this.viewer);
    }

    public void dispose() {
        RahmenwerkService.getService().getRahmenWerk().removeDavVerbindungsListener((DavVerbindungsListener)this.verbindungsListener);
        super.dispose();
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    private final class VerbindungsListener
    implements DavVerbindungsListener {
        private VerbindungsListener() {
        }

        public void verbindungHergestellt(DavVerbindungsEvent event) {
            RahmenwerkService service = RahmenwerkService.getService();
            Collection<Region> regionen = RahmenwerkService.getService().getBenutzerverwaltung().getRegionen();
            List collect = regionen.stream().map(r -> service.getObjektFactory().getModellobjekt(r.getSystemObject())).collect(Collectors.toList());
            RegionenView.this.viewer.setInput(collect);
        }

        public boolean verbindungHalten(DavVerbindungsEvent event) {
            return false;
        }

        public void verbindungGetrennt(DavVerbindungsEvent event) {
            RegionenView.this.viewer.setInput((Object)new Object[0]);
        }
    }
}

