/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.benutzervew.wizards;

import de.bsvrz.buv.plugin.benutzervew.data.Benutzer;
import de.bsvrz.buv.plugin.benutzervew.data.BenutzerChangeException;
import de.bsvrz.buv.plugin.benutzervew.data.BenutzerInfo;
import de.bsvrz.buv.plugin.benutzervew.data.Benutzerverwaltung;
import de.bsvrz.buv.plugin.benutzervew.data.BerechtigungsKlasse;
import de.bsvrz.buv.plugin.benutzervew.data.KeineRechteException;
import de.bsvrz.buv.plugin.benutzervew.internal.RahmenwerkService;
import de.bsvrz.buv.plugin.benutzervew.wizards.BenutzerAnlegenWizardPage;
import de.bsvrz.buv.plugin.benutzervew.wizards.BenutzerBerechtigungsKlassenWizardPage;
import de.bsvrz.buv.plugin.benutzervew.wizards.BenutzerEinmalPassworteWizardPage;
import de.bsvrz.buv.rw.basislib.Rahmenwerk;
import de.bsvrz.buv.rw.basislib.urlasser.UrlasserInfoDatenDialog;
import de.bsvrz.puk.param.lib.daten.UrlasserInfo;
import de.bsvrz.sys.funclib.debug.Debug;
import java.util.Collection;
import java.util.Map;
import java.util.SortedMap;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public class BenutzerAnlegenWizard
extends Wizard
implements INewWizard {
    private BenutzerAnlegenWizardPage page;
    private BenutzerBerechtigungsKlassenWizardPage pageKlassen;
    private BenutzerEinmalPassworteWizardPage pageRechte;
    private final Debug debug = Debug.getLogger();
    private final BerechtigungsKlasse berechtigungsKlasse;

    public BenutzerAnlegenWizard(BerechtigungsKlasse berechtigungsKlasse) {
        this.berechtigungsKlasse = berechtigungsKlasse;
        this.setWindowTitle("Benutzer anlegen");
    }

    public void addPages() {
        this.page = new BenutzerAnlegenWizardPage(null, this.berechtigungsKlasse);
        this.addPage((IWizardPage)this.page);
        this.pageKlassen = new BenutzerBerechtigungsKlassenWizardPage(this.berechtigungsKlasse);
        this.addPage((IWizardPage)this.pageKlassen);
        this.pageRechte = new BenutzerEinmalPassworteWizardPage(null);
        this.addPage((IWizardPage)this.pageRechte);
    }

    private boolean createUser() {
        Rahmenwerk rahmenwerk = RahmenwerkService.getService().getRahmenWerk();
        if (!rahmenwerk.isOnline()) {
            return false;
        }
        Benutzerverwaltung bv = RahmenwerkService.getService().getBenutzerverwaltung();
        String loginname = this.page.getLoginname();
        Collection<BerechtigungsKlasse> klassen = this.pageKlassen.getBerechtigungsklassen();
        Assert.isNotNull((Object)loginname);
        Assert.isTrue((loginname.length() > 0 ? 1 : 0) != 0);
        Benutzer b = bv.getBenutzer(loginname);
        if (b != null) {
            this.page.setErrorMessage("Der Nutzer " + loginname + " existiert bereits!");
            return false;
        }
        BenutzerInfo benutzerInfo = new BenutzerInfo();
        benutzerInfo.setPasswort(this.page.getPasswort());
        benutzerInfo.setNachname(this.page.getNachname());
        benutzerInfo.setVorname(this.page.getVorname());
        benutzerInfo.setZweiterVorname(this.page.getZweiterVorname());
        benutzerInfo.setEmailAdresse(this.page.getEmailAdresse());
        benutzerInfo.setOrganisation(this.page.getOrganisation());
        UrlasserInfoDatenDialog dialog = new UrlasserInfoDatenDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (verbindung, urlasser) -> {});
        dialog.setInitialBenutzer(rahmenwerk.getBenutzerName());
        dialog.setInitialUrsache("Benutzer '" + loginname + "' angelegt");
        dialog.setInitialVeranlasser(rahmenwerk.getBenutzerName());
        if (dialog.open() != 0) {
            return false;
        }
        UrlasserInfo uinfo = dialog.getUrlasserInfo();
        String adminLoginname = uinfo.getBenutzerName();
        String adminPasswort = uinfo.getPasswort();
        try {
            Benutzer benutzer = bv.anlegenBenutzer(adminLoginname, adminPasswort, loginname, benutzerInfo, this.page.isAdmin());
            SortedMap<Integer, String> einmalPassworte = bv.setEinmalPassworte(adminLoginname, adminPasswort, loginname, this.pageRechte.getEinmalPassworte());
            bv.setBerechtigungsklassen(adminLoginname, adminPasswort, benutzer, klassen, uinfo);
            if (!einmalPassworte.isEmpty()) {
                StringBuilder message = new StringBuilder();
                message.append("F\u00fcr den Benutzer '");
                message.append(benutzer.getName());
                message.append("' wurden folgende Einmalpassworte angelegt.\n\n");
                for (Map.Entry<Integer, String> einmalPasswort : einmalPassworte.entrySet()) {
                    message.append(einmalPasswort.getKey());
                    message.append(" - ");
                    message.append(einmalPasswort.getValue());
                    message.append('\n');
                }
                MessageDialog.openInformation((Shell)this.getShell(), (String)"INFORMATION", (String)message.toString());
            }
        }
        catch (KeineRechteException ex) {
            String s = ex.getLocalizedMessage();
            if (ex.getCause() != null) {
                s = String.valueOf(s) + " " + ex.getCause().getLocalizedMessage();
            }
            this.page.setErrorMessage(s);
            this.debug.error(s);
            return false;
        }
        catch (BenutzerChangeException ex) {
            String s = ex.getLocalizedMessage();
            if (ex.getCause() != null) {
                s = String.valueOf(s) + " " + ex.getCause().getLocalizedMessage();
            }
            this.page.setErrorMessage(s);
            this.debug.error(s);
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Fehler", (String)s);
            return false;
        }
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public boolean performFinish() {
        return this.createUser();
    }
}

