/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.benutzervew.wizards;

import de.bsvrz.buv.plugin.benutzervew.data.Benutzer;
import de.bsvrz.buv.plugin.benutzervew.data.Benutzerverwaltung;
import de.bsvrz.buv.plugin.benutzervew.data.BerechtigungsKlasse;
import de.bsvrz.buv.plugin.benutzervew.data.PasswortInfo;
import de.bsvrz.buv.plugin.benutzervew.internal.RahmenwerkService;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class BenutzerAnlegenWizardPage
extends WizardPage {
    private static final String HILFE_ID = "de.bsvrz.buv.plugin.benutzervew." + BenutzerAnlegenWizardPage.class.getSimpleName();
    private Text loginname;
    private Text nachname;
    private Text vorname;
    private Text zweiterVorname;
    private Text emailAdresse;
    private Text organisation;
    private Text passwort;
    private Text passwortRepeat;
    private boolean adminFlag;
    private final Benutzer benutzer;
    private final boolean editable = true;
    private Button adminButton;
    private final PasswortInfo passWortInfo;

    public BenutzerAnlegenWizardPage(Benutzer benutzer, BerechtigungsKlasse klasse) {
        super("Nutzer");
        this.benutzer = benutzer;
        this.setTitle("Geben Sie die Daten f\u00fcr den neuen Nutzer ein:");
        this.passWortInfo = new PasswortInfo();
        this.passWortInfo.setMinLaenge(5L);
    }

    public void createControl(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, HILFE_ID);
        Composite panel = new Composite(parent, 0);
        GridLayout pageLayout = new GridLayout();
        pageLayout.numColumns = 2;
        panel.setLayout((Layout)pageLayout);
        panel.setLayoutData((Object)new GridData(768));
        Label label = new Label(panel, 0);
        label.setText("Nutzername:");
        this.loginname = new Text(panel, 2052);
        GridData gridData = new GridData(768);
        this.loginname.setLayoutData((Object)gridData);
        if (this.benutzer != null) {
            this.loginname.setText(this.benutzer.getName());
            this.loginname.setEnabled(false);
        }
        this.loginname.addModifyListener(event -> this.checkInput());
        label = new Label(panel, 0);
        label.setText("Nachname:");
        this.nachname = new Text(panel, 2052);
        gridData = new GridData(768);
        this.nachname.setLayoutData((Object)gridData);
        this.nachname.setEnabled(true);
        if (this.benutzer != null) {
            this.nachname.setText(this.benutzer.getNachname());
            this.nachname.setEnabled(false);
        }
        this.nachname.addModifyListener(event -> this.checkInput());
        label = new Label(panel, 0);
        label.setText("Vorname:");
        this.vorname = new Text(panel, 2052);
        gridData = new GridData(768);
        this.vorname.setLayoutData((Object)gridData);
        this.vorname.setEnabled(true);
        if (this.benutzer != null) {
            this.vorname.setText(this.benutzer.getVorname());
            this.vorname.setEnabled(false);
        }
        this.vorname.addModifyListener(event -> this.checkInput());
        label = new Label(panel, 0);
        label.setText("Zweiter Vorname:");
        this.zweiterVorname = new Text(panel, 2052);
        gridData = new GridData(768);
        this.zweiterVorname.setLayoutData((Object)gridData);
        this.zweiterVorname.setEnabled(true);
        if (this.benutzer != null) {
            this.zweiterVorname.setText(this.benutzer.getZweiterVorname());
            this.zweiterVorname.setEnabled(false);
        }
        label = new Label(panel, 0);
        label.setText("E-Mail:");
        this.emailAdresse = new Text(panel, 2052);
        gridData = new GridData(768);
        this.emailAdresse.setLayoutData((Object)gridData);
        this.emailAdresse.setEnabled(true);
        if (this.benutzer != null) {
            this.emailAdresse.setText(this.benutzer.getEmailAdresse());
            this.emailAdresse.setEnabled(false);
        }
        label = new Label(panel, 0);
        label.setText("Organisation:");
        this.organisation = new Text(panel, 2052);
        gridData = new GridData(768);
        this.organisation.setLayoutData((Object)gridData);
        this.organisation.setEnabled(true);
        if (this.benutzer != null) {
            this.organisation.setText(this.benutzer.getOrganisation());
            this.organisation.setEnabled(false);
        }
        label = new Label(panel, 0);
        label.setText("Passwort:");
        this.passwort = new Text(panel, 0x400800);
        gridData = new GridData(768);
        this.passwort.setLayoutData((Object)gridData);
        this.passwort.addModifyListener(event -> this.checkInput());
        label = new Label(panel, 0);
        label.setText("Passwort best\u00e4tigen:");
        this.passwortRepeat = new Text(panel, 0x400800);
        gridData = new GridData(768);
        this.passwortRepeat.setLayoutData((Object)gridData);
        this.passwortRepeat.addModifyListener(event -> this.checkInput());
        label = new Label(panel, 0);
        label.setText("Benutzer ist Administrator:");
        this.adminButton = new Button(panel, 32);
        this.adminButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BenutzerAnlegenWizardPage.this.adminFlag = BenutzerAnlegenWizardPage.this.adminButton.getSelection();
            }
        });
        this.checkInput();
        this.setControl((Control)panel);
    }

    public boolean isBearbeiten() {
        return this.benutzer != null;
    }

    public Benutzer getBenutzer() {
        return this.benutzer;
    }

    public String getPasswort() {
        return this.passwort.getText();
    }

    public String getPasswortRepeat() {
        return this.passwortRepeat.getText();
    }

    public String getLoginname() {
        return this.loginname.getText();
    }

    public String getVorname() {
        return this.vorname.getText();
    }

    public String getNachname() {
        return this.nachname.getText();
    }

    public String getZweiterVorname() {
        return this.zweiterVorname.getText();
    }

    public String getEmailAdresse() {
        return this.emailAdresse.getText();
    }

    public String getOrganisation() {
        return this.organisation.getText();
    }

    public boolean isAdmin() {
        return this.adminFlag;
    }

    private void checkInput() {
        String passwortCheck;
        String errorMsg = null;
        Benutzerverwaltung bv = RahmenwerkService.getService().getBenutzerverwaltung();
        if (this.getLoginname().length() == 0) {
            errorMsg = "Sie m\u00fcssen einen Nutzernamen eingeben.";
        }
        if (this.getBenutzer() == null) {
            if (this.getLoginname().length() > 0 && bv.getBenutzer(this.getLoginname()) != null) {
                errorMsg = "Es existiert bereits ein Benutzer mit dieser Kennung im System.";
            }
            if (errorMsg == null && this.getNachname().length() == 0) {
                errorMsg = "Sie m\u00fcssen den Nachnamen eingeben.";
            } else if (errorMsg == null && this.getVorname().length() == 0) {
                errorMsg = "Sie m\u00fcssen den Vornamen eingeben.";
            }
        }
        if (errorMsg == null && (passwortCheck = bv.checkPasswort(this.getPasswort(), null, this.passWortInfo)) != null) {
            errorMsg = passwortCheck;
        }
        if (errorMsg == null && !this.getPasswort().equals(this.getPasswortRepeat())) {
            errorMsg = "Das Passwort stimmt nicht mit der Wiederholung \u00fcberein";
        }
        this.setMessage(errorMsg, 2);
        this.setPageComplete(errorMsg == null);
    }
}

