/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.benutzervew.wizards;

import de.bsvrz.buv.plugin.benutzervew.data.Benutzer;
import de.bsvrz.buv.plugin.benutzervew.data.BenutzerChangeException;
import de.bsvrz.buv.plugin.benutzervew.data.Benutzerverwaltung;
import de.bsvrz.buv.plugin.benutzervew.data.KeineRechteException;
import de.bsvrz.buv.plugin.benutzervew.internal.RahmenwerkService;
import de.bsvrz.buv.plugin.benutzervew.wizards.BenutzerBerechtigungsKlassenWizardPage;
import de.bsvrz.buv.plugin.benutzervew.wizards.BenutzerEinmalPassworteWizardPage;
import de.bsvrz.buv.rw.basislib.Rahmenwerk;
import de.bsvrz.buv.rw.basislib.urlasser.UrlasserInfoDatenDialog;
import de.bsvrz.puk.param.lib.daten.UrlasserInfo;
import de.bsvrz.sys.funclib.debug.Debug;
import java.util.Map;
import java.util.SortedMap;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public class BenutzerBearbeitenWizard
extends Wizard
implements INewWizard {
    private BenutzerBerechtigungsKlassenWizardPage page;
    private BenutzerEinmalPassworteWizardPage pageRechte;
    private final Benutzer benutzer;
    private final Debug log = Debug.getLogger();

    public BenutzerBearbeitenWizard(Benutzer benutzer) {
        Assert.isNotNull((Object)benutzer, (String)"Der Benutzer darf nicht null sein.");
        this.setWindowTitle("Benutzerberechtigungen bearbeiten");
        this.benutzer = benutzer;
    }

    public void addPages() {
        this.page = new BenutzerBerechtigungsKlassenWizardPage(this.benutzer);
        this.addPage((IWizardPage)this.page);
        this.pageRechte = new BenutzerEinmalPassworteWizardPage(this.benutzer);
        this.addPage((IWizardPage)this.pageRechte);
    }

    private boolean changeUser() {
        Rahmenwerk rahmenwerk = RahmenwerkService.getService().getRahmenWerk();
        if (!rahmenwerk.isOnline()) {
            return false;
        }
        UrlasserInfoDatenDialog dialog = new UrlasserInfoDatenDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (verbindung, urlasser) -> {});
        dialog.setInitialBenutzer(rahmenwerk.getBenutzerName());
        dialog.setInitialUrsache("Benutzer '" + this.benutzer.getName() + "' bearbeitet");
        dialog.setInitialVeranlasser(rahmenwerk.getBenutzerName());
        if (dialog.open() != 0) {
            return false;
        }
        UrlasserInfo uinfo = dialog.getUrlasserInfo();
        String adminLoginname = uinfo.getBenutzerName();
        String adminPasswort = uinfo.getPasswort();
        Benutzerverwaltung bv = RahmenwerkService.getService().getBenutzerverwaltung();
        try {
            bv.setBerechtigungsklassen(adminLoginname, adminPasswort, this.benutzer, this.page.getBerechtigungsklassen(), uinfo);
            SortedMap<Integer, String> einmalPassworte = bv.setEinmalPassworte(adminLoginname, adminPasswort, this.benutzer.getName(), this.pageRechte.getEinmalPassworte());
            if (!einmalPassworte.isEmpty()) {
                StringBuilder message = new StringBuilder();
                message.append("F\u00fcr den Benutzer '");
                message.append(this.benutzer.getName());
                message.append("' wurden folgende Einmalpassworte angelegt.\n\n");
                for (Map.Entry<Integer, String> einmalPasswort : einmalPassworte.entrySet()) {
                    message.append(einmalPasswort.getKey());
                    message.append(" - ");
                    message.append(einmalPasswort.getValue());
                    message.append('\n');
                }
                MessageDialog.openInformation((Shell)this.getShell(), (String)"INFORMATION", (String)message.toString());
            }
        }
        catch (KeineRechteException ex) {
            String s = ex.getLocalizedMessage();
            if (ex.getCause() != null) {
                s = String.valueOf(s) + " " + ex.getCause().getLocalizedMessage();
            }
            this.page.setErrorMessage(s);
            this.log.error(ex.getLocalizedMessage(), (Throwable)ex);
            return false;
        }
        catch (BenutzerChangeException ex) {
            String s = ex.getLocalizedMessage();
            if (ex.getCause() != null) {
                s = String.valueOf(s) + " " + ex.getCause().getLocalizedMessage();
            }
            this.page.setErrorMessage(s);
            this.log.error(ex.getLocalizedMessage(), (Throwable)ex);
            return false;
        }
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public boolean performFinish() {
        return this.changeUser();
    }
}

