/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.benutzervew.wizards;

import de.bsvrz.buv.plugin.benutzervew.data.Benutzer;
import de.bsvrz.buv.plugin.benutzervew.data.BenutzerChangeException;
import de.bsvrz.buv.plugin.benutzervew.data.Benutzerverwaltung;
import de.bsvrz.buv.plugin.benutzervew.data.KeineRechteException;
import de.bsvrz.buv.plugin.benutzervew.internal.RahmenwerkService;
import de.bsvrz.buv.plugin.benutzervew.wizards.BenutzerPasswortWizardPage;
import de.bsvrz.sys.funclib.debug.Debug;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class BenutzerPasswortWizard
extends Wizard
implements INewWizard {
    private BenutzerPasswortWizardPage page;
    private final Benutzer benutzer;
    private final Debug log = Debug.getLogger();

    public BenutzerPasswortWizard(Benutzer benutzer) {
        Assert.isNotNull((Object)benutzer, (String)"Der Benutzer darf nicht null sein.");
        Benutzerverwaltung bv = RahmenwerkService.getService().getBenutzerverwaltung();
        if (benutzer == bv.getAngemeldetenBenutzer()) {
            this.setWindowTitle("Eigenes Passwort \u00e4ndern");
        } else {
            this.setWindowTitle("Benutzerpasswort \u00e4ndern");
        }
        this.benutzer = benutzer;
    }

    public void addPages() {
        this.page = new BenutzerPasswortWizardPage(this.benutzer);
        this.addPage((IWizardPage)this.page);
    }

    private boolean changeUserPasswort() {
        String ordererPasswort;
        String ordererName;
        Benutzerverwaltung bv = RahmenwerkService.getService().getBenutzerverwaltung();
        if (this.benutzer == bv.getAngemeldetenBenutzer()) {
            ordererName = RahmenwerkService.getService().getRahmenWerk().getBenutzerName();
            ordererPasswort = this.page.getPasswortAktuell();
        } else {
            ordererName = RahmenwerkService.getService().getRahmenWerk().getBenutzerName();
            ordererPasswort = RahmenwerkService.getService().getRahmenWerk().getPasswort();
        }
        try {
            bv.aendernPasswort(ordererName, ordererPasswort, this.benutzer, this.page.getPasswort());
        }
        catch (KeineRechteException ex) {
            String s = ex.getLocalizedMessage();
            if (ex.getCause() != null) {
                s = String.valueOf(s) + " " + ex.getCause().getLocalizedMessage();
            }
            this.page.setErrorMessage(s);
            this.log.error(ex.getLocalizedMessage(), (Throwable)ex);
            return false;
        }
        catch (BenutzerChangeException ex) {
            String s = ex.getLocalizedMessage();
            if (ex.getCause() != null) {
                s = String.valueOf(s) + " " + ex.getCause().getLocalizedMessage();
            }
            this.page.setErrorMessage(s);
            this.log.error(ex.getLocalizedMessage(), (Throwable)ex);
            return false;
        }
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public boolean performFinish() {
        return this.changeUserPasswort();
    }
}

