/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.benutzervew.wizards;

import de.bsvrz.buv.plugin.benutzervew.data.Benutzer;
import de.bsvrz.buv.plugin.benutzervew.data.Benutzerverwaltung;
import de.bsvrz.buv.plugin.benutzervew.data.PasswortInfo;
import de.bsvrz.buv.plugin.benutzervew.internal.RahmenwerkService;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class BenutzerPasswortWizardPage
extends WizardPage {
    private static final String HILFE_ID = "de.bsvrz.buv.plugin.benutzervew." + BenutzerPasswortWizardPage.class.getSimpleName();
    private Text aktuellesPasswort;
    private Text passwort;
    private Text passwortRepeat;
    private final Benutzer benutzer;
    private final boolean editable = true;
    private final PasswortInfo passWortInfo;
    private final boolean istEigenesPasswort;

    public BenutzerPasswortWizardPage(Benutzer benutzer) {
        super("Benutzer");
        this.benutzer = benutzer;
        this.istEigenesPasswort = benutzer == null || benutzer.getName().equals(RahmenwerkService.getService().getRahmenWerk().getBenutzerName());
        this.setTitle("Geben Sie ein neues Passwort f\u00fcr den Benutzer '" + (benutzer == null ? null : benutzer.getName()) + "' an");
        this.passWortInfo = new PasswortInfo();
        this.passWortInfo.setMinLaenge(5L);
    }

    public void createControl(Composite parent) {
        GridData gridData;
        Label label;
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, HILFE_ID);
        Composite panel = new Composite(parent, 0);
        ChangeListener changeListener = new ChangeListener();
        GridLayout pageLayout = new GridLayout();
        pageLayout.numColumns = 2;
        panel.setLayout((Layout)pageLayout);
        panel.setLayoutData((Object)new GridData(768));
        if (this.istEigenesPasswort) {
            label = new Label(panel, 0);
            label.setText("aktuelles Passwort:");
            this.aktuellesPasswort = new Text(panel, 0x400800);
            gridData = new GridData(768);
            this.aktuellesPasswort.setLayoutData((Object)gridData);
            this.aktuellesPasswort.addModifyListener((ModifyListener)changeListener);
        }
        label = new Label(panel, 0);
        label.setText("neues Passwort:");
        this.passwort = new Text(panel, 0x400800);
        gridData = new GridData(768);
        this.passwort.setLayoutData((Object)gridData);
        this.passwort.addModifyListener((ModifyListener)changeListener);
        label = new Label(panel, 0);
        label.setText("neues Passwort best\u00e4tigen:");
        this.passwortRepeat = new Text(panel, 0x400800);
        gridData = new GridData(768);
        this.passwortRepeat.setLayoutData((Object)gridData);
        this.passwortRepeat.addModifyListener((ModifyListener)changeListener);
        this.checkInput();
        this.setControl((Control)panel);
    }

    public boolean isBearbeiten() {
        return this.benutzer != null;
    }

    public Benutzer getBenutzer() {
        return this.benutzer;
    }

    public String getPasswortAktuell() {
        if (this.aktuellesPasswort != null) {
            return this.aktuellesPasswort.getText();
        }
        return null;
    }

    public String getPasswort() {
        return this.passwort.getText();
    }

    public String getPasswortRepeat() {
        return this.passwortRepeat.getText();
    }

    private void checkInput() {
        Benutzerverwaltung bv = RahmenwerkService.getService().getBenutzerverwaltung();
        String errorMsg = bv.checkPasswort(this.getPasswort(), null, this.passWortInfo);
        if (errorMsg == null && !this.getPasswort().equals(this.getPasswortRepeat())) {
            errorMsg = "Das neue Passwort stimmt nicht mit der Wiederholung \u00fcberein";
        }
        this.setMessage(errorMsg, 2);
        this.setPageComplete(errorMsg == null);
    }

    private class ChangeListener
    implements ModifyListener {
        private ChangeListener() {
        }

        public void modifyText(ModifyEvent e) {
            BenutzerPasswortWizardPage.this.checkInput();
        }
    }
}

