/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.benutzervew.wizards;

import de.bsvrz.buv.plugin.benutzervew.data.BerechtigungsKlasse;
import de.bsvrz.buv.plugin.benutzervew.internal.RahmenwerkService;
import de.bsvrz.buv.plugin.benutzervew.wizards.BerechtigungsklasseWizardPage;
import de.bsvrz.buv.rw.basislib.Rahmenwerk;
import de.bsvrz.buv.rw.basislib.urlasser.UrlasserInfoDatenDialog;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class BerechtigungsklasseWizard
extends Wizard
implements INewWizard {
    private BerechtigungsklasseWizardPage page;
    private final BerechtigungsKlasse klasse;

    public BerechtigungsklasseWizard(BerechtigungsKlasse klasse) {
        Assert.isNotNull((Object)klasse, (String)"Die Berechtigungsklasse darf nicht null sein.");
        this.setWindowTitle("Berechtigungsklasse bearbeiten");
        this.klasse = klasse;
    }

    public void addPages() {
        this.page = new BerechtigungsklasseWizardPage(this.klasse);
        this.addPage((IWizardPage)this.page);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public boolean performFinish() {
        Rahmenwerk rahmenwerk = RahmenwerkService.getService().getRahmenWerk();
        if (!rahmenwerk.isOnline()) {
            return false;
        }
        UrlasserInfoDatenDialog dialog = new UrlasserInfoDatenDialog(new Shell(Display.getDefault()), (verbindung, urlasser) -> this.klasse.sendeRolleRegionenPaare(this.page.getRollenRegionenPaare(), urlasser));
        dialog.setInitialBenutzer(rahmenwerk.getBenutzerName());
        dialog.setInitialVeranlasser(rahmenwerk.getBenutzerName());
        dialog.setInitialUrsache("Berechtigungsklasse '" + this.klasse.getName() + "' ge\u00e4ndert");
        return dialog.open() == 0;
    }
}

