/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.benutzervew.wizards;

import de.bsvrz.buv.plugin.benutzervew.data.Benutzerverwaltung;
import de.bsvrz.buv.plugin.benutzervew.data.BerechtigungsKlasse;
import de.bsvrz.buv.plugin.benutzervew.data.Region;
import de.bsvrz.buv.plugin.benutzervew.data.Rolle;
import de.bsvrz.buv.plugin.benutzervew.data.RolleRegionPaar;
import de.bsvrz.buv.plugin.benutzervew.internal.RahmenwerkService;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.PlatformUI;

public class BerechtigungsklasseWizardPage
extends WizardPage {
    private static final String HILFE_ID = "de.bsvrz.buv.plugin.benutzervew." + BerechtigungsklasseWizardPage.class.getSimpleName();
    private TableViewer zuordnungsViewer;
    private ListViewer rollenListe;
    private ListViewer regionenListe;
    private Button addButton;
    private Button removeButton;
    private final Collection<RolleRegionPaar> rollenRegionenPaare = new LinkedHashSet<RolleRegionPaar>();

    public BerechtigungsklasseWizardPage(BerechtigungsKlasse klasse) {
        super("Berechtigungsklasse");
        this.setTitle("Stellen Sie hier die Rollen-/Regionenpaare der Berechtigungsklasse '" + klasse.getName() + "' zusammen");
        this.rollenRegionenPaare.addAll(klasse.getRolleRegionenPaare());
    }

    public void createControl(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, HILFE_ID);
        Benutzerverwaltung bv = RahmenwerkService.getService().getBenutzerverwaltung();
        Composite panel = new Composite(parent, 0);
        panel.setLayout((Layout)new GridLayout(3, false));
        Group aGruppe = new Group(panel, 16);
        aGruppe.setText("Verf\u00fcgbare Rollen:");
        aGruppe.setLayout((Layout)new GridLayout());
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)aGruppe);
        this.rollenListe = new ListViewer((Composite)aGruppe, 4);
        this.rollenListe.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.rollenListe.setInput(bv.getRollen());
        this.rollenListe.addSelectionChangedListener(event -> this.updateButtons());
        GridDataFactory.fillDefaults().grab(true, true).applyTo(this.rollenListe.getControl());
        Composite buttonPanel = new Composite(panel, 0);
        buttonPanel.setLayout((Layout)new GridLayout());
        GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).applyTo((Control)buttonPanel);
        this.addButton = new Button(buttonPanel, 8);
        this.addButton.setText(" >> ");
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BerechtigungsklasseWizardPage.this.rollenRegionenPaare.add(BerechtigungsklasseWizardPage.this.getSelectedRolleRegionPaar());
                BerechtigungsklasseWizardPage.this.getShell().getDisplay().asyncExec(() -> BerechtigungsklasseWizardPage.this.zuordnungsViewer.refresh());
            }
        });
        this.removeButton = new Button(buttonPanel, 8);
        this.removeButton.setText(" << ");
        this.removeButton.setEnabled(false);
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BerechtigungsklasseWizardPage.this.rollenRegionenPaare.removeAll(((IStructuredSelection)BerechtigungsklasseWizardPage.this.zuordnungsViewer.getSelection()).toList());
                BerechtigungsklasseWizardPage.this.getShell().getDisplay().asyncExec(() -> BerechtigungsklasseWizardPage.this.zuordnungsViewer.refresh());
            }
        });
        this.erzeugeRollenRegionenTabelle(panel);
        aGruppe = new Group(panel, 16);
        aGruppe.setText("Verf\u00fcgbare Regionen:");
        aGruppe.setLayout((Layout)new GridLayout());
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)aGruppe);
        this.regionenListe = new ListViewer((Composite)aGruppe, 4);
        this.regionenListe.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.regionenListe.setComparator(new ViewerComparator());
        this.regionenListe.setInput(bv.getRegionen());
        this.regionenListe.addSelectionChangedListener(event -> this.updateButtons());
        GridDataFactory.fillDefaults().grab(true, true).applyTo(this.regionenListe.getControl());
        this.addButton.setEnabled(false);
        this.setControl((Control)panel);
    }

    private void updateButtons() {
        this.addButton.setEnabled(!this.regionenListe.getSelection().isEmpty() && !this.rollenListe.getSelection().isEmpty());
        this.removeButton.setEnabled(!this.zuordnungsViewer.getSelection().isEmpty());
    }

    private void erzeugeRollenRegionenTabelle(Composite parent) {
        Group adminGruppe = new Group(parent, 16);
        GridDataFactory.fillDefaults().grab(true, true).span(1, 2).applyTo((Control)adminGruppe);
        adminGruppe.setText("Rollen-/Regionenpaare der Berechtigungsklasse:");
        adminGruppe.setLayout((Layout)new GridLayout(1, false));
        this.zuordnungsViewer = new TableViewer((Composite)adminGruppe, 67584);
        this.zuordnungsViewer.getTable().setHeaderVisible(true);
        this.zuordnungsViewer.getTable().setLinesVisible(true);
        GridDataFactory.fillDefaults().grab(true, true).span(1, 2).applyTo(this.zuordnungsViewer.getControl());
        TableLayout tabLayout = new TableLayout();
        TableColumn column = new TableColumn(this.zuordnungsViewer.getTable(), 0);
        column.setText("Zugriffsrolle");
        tabLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(1));
        column = new TableColumn(this.zuordnungsViewer.getTable(), 0);
        column.setText("Zugriffsregion");
        tabLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(1));
        this.zuordnungsViewer.getTable().setLayout((Layout)tabLayout);
        this.zuordnungsViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.zuordnungsViewer.setLabelProvider((IBaseLabelProvider)new ZuordnungsLabelProvider());
        this.zuordnungsViewer.setInput(this.rollenRegionenPaare);
        this.zuordnungsViewer.addSelectionChangedListener(event -> this.updateButtons());
    }

    private RolleRegionPaar getSelectedRolleRegionPaar() {
        Region region = (Region)((IStructuredSelection)this.regionenListe.getSelection()).getFirstElement();
        Rolle rolle = (Rolle)((IStructuredSelection)this.rollenListe.getSelection()).getFirstElement();
        return new RolleRegionPaar(rolle, region);
    }

    public Collection<RolleRegionPaar> getRollenRegionenPaare() {
        return this.rollenRegionenPaare;
    }

    private static final class ZuordnungsLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private ZuordnungsLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof RolleRegionPaar) {
                RolleRegionPaar paar = (RolleRegionPaar)element;
                switch (columnIndex) {
                    case 0: {
                        return paar.getRolle().toString();
                    }
                    case 1: {
                        return paar.getRegion().toString();
                    }
                }
            }
            return "";
        }
    }
}

